
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * OPTIONAL SERVICE TO BE PRICED definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceQualifierPriceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ServiceEncodingType" name="Encoding"/>
 *     &lt;xs:element name="Fulfillment" minOccurs="0">
 *       &lt;!-- Reference to inner class Fulfillment -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Associations" minOccurs="0">
 *       &lt;!-- Reference to inner class Associations -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:boolean" default="true" name="Include"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ServiceQualifierPriceType implements Serializable
{
    private ServiceEncodingType encoding;
    private Fulfillment fulfillment;
    private Associations associations;
    private boolean include;
    private String refs;

    /** 
     * Get the 'Encoding' element value. Service Codes and Reason for Issuance.
     * 
     * @return value
     */
    public ServiceEncodingType getEncoding() {
        return encoding;
    }

    /** 
     * Set the 'Encoding' element value. Service Codes and Reason for Issuance.
     * 
     * @param encoding
     */
    public void setEncoding(ServiceEncodingType encoding) {
        this.encoding = encoding;
    }

    /** 
     * Get the 'Fulfillment' element value.
     * 
     * @return value
     */
    public Fulfillment getFulfillment() {
        return fulfillment;
    }

    /** 
     * Set the 'Fulfillment' element value.
     * 
     * @param fulfillment
     */
    public void setFulfillment(Fulfillment fulfillment) {
        this.fulfillment = fulfillment;
    }

    /** 
     * Get the 'Associations' element value.
     * 
     * @return value
     */
    public Associations getAssociations() {
        return associations;
    }

    /** 
     * Set the 'Associations' element value.
     * 
     * @param associations
     */
    public void setAssociations(Associations associations) {
        this.associations = associations;
    }

    /** 
     * Get the 'Include' element value. Exclude=false , Include=true, Default value is true
     * 
     * @return value
     */
    public boolean isInclude() {
        return include;
    }

    /** 
     * Set the 'Include' element value. Exclude=false , Include=true, Default value is true
     * 
     * @param include
     */
    public void setInclude(boolean include) {
        this.include = include;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Fulfillment detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fulfillment" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="OfferValidDates" minOccurs="0">
     *         &lt;!-- Reference to inner class OfferValidDates -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:FulfillmentPartnerType" name="Provider" minOccurs="0"/>
     *       &lt;xs:element name="Location" minOccurs="0">
     *         &lt;!-- Reference to inner class Location -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Fulfillment implements Serializable
    {
        private OfferValidDates offerValidDates;
        private FulfillmentPartnerType provider;
        private Location location;
        private String refs;

        /** 
         * Get the 'OfferValidDates' element value.
         * 
         * @return value
         */
        public OfferValidDates getOfferValidDates() {
            return offerValidDates;
        }

        /** 
         * Set the 'OfferValidDates' element value.
         * 
         * @param offerValidDates
         */
        public void setOfferValidDates(OfferValidDates offerValidDates) {
            this.offerValidDates = offerValidDates;
        }

        /** 
         * Get the 'Provider' element value. Information about the company or party that will fulfill the service.
         * 
         * @return value
         */
        public FulfillmentPartnerType getProvider() {
            return provider;
        }

        /** 
         * Set the 'Provider' element value. Information about the company or party that will fulfill the service.
         * 
         * @param provider
         */
        public void setProvider(FulfillmentPartnerType provider) {
            this.provider = provider;
        }

        /** 
         * Get the 'Location' element value.
         * 
         * @return value
         */
        public Location getLocation() {
            return location;
        }

        /** 
         * Set the 'Location' element value.
         * 
         * @param location
         */
        public void setLocation(Location location) {
            this.location = location;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
        /** 
         * Service Fulfillment Period.

        Note: This is the start and end date/time period(s) the service may be fullfilled or used.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferValidDates" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:CoreDateGrpType" name="Start" minOccurs="0"/>
         *       &lt;xs:element type="ns:CoreDateGrpType" name="End" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OfferValidDates implements Serializable
        {
            private CoreDateGrpType start;
            private CoreDateGrpType end;

            /** 
             * Get the 'Start' element value. The EARLIEST date the associated optional service is available or may be used.  Example: 2017-01-13
             * 
             * @return value
             */
            public CoreDateGrpType getStart() {
                return start;
            }

            /** 
             * Set the 'Start' element value. The EARLIEST date the associated optional service is available or may be used.  Example: 2017-01-13
             * 
             * @param start
             */
            public void setStart(CoreDateGrpType start) {
                this.start = start;
            }

            /** 
             * Get the 'End' element value. The LATEST date the associated optional service is available or may be used. Example: 2017-03-13
             * 
             * @return value
             */
            public CoreDateGrpType getEnd() {
                return end;
            }

            /** 
             * Set the 'End' element value. The LATEST date the associated optional service is available or may be used. Example: 2017-03-13
             * 
             * @param end
             */
            public void setEnd(CoreDateGrpType end) {
                this.end = end;
            }
        }
        /** 
         * Information about the location where the service will be fulfilled.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Location" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:AirportFulfillmentLocation"/>
         *       &lt;xs:element ref="ns:OtherFulfillmentLocation"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Location implements Serializable
        {
            private SrvcLocationAirportType airportFulfillmentLocation;
            private SrvcLocationAddressType otherFulfillmentLocation;

            /** 
             * Get the 'AirportFulfillmentLocation' element value. .
             * 
             * @return value
             */
            public SrvcLocationAirportType getAirportFulfillmentLocation() {
                return airportFulfillmentLocation;
            }

            /** 
             * Set the 'AirportFulfillmentLocation' element value. .
             * 
             * @param airportFulfillmentLocation
             */
            public void setAirportFulfillmentLocation(
                    SrvcLocationAirportType airportFulfillmentLocation) {
                this.airportFulfillmentLocation = airportFulfillmentLocation;
            }

            /** 
             * Get the 'OtherFulfillmentLocation' element value.
             * 
             * @return value
             */
            public SrvcLocationAddressType getOtherFulfillmentLocation() {
                return otherFulfillmentLocation;
            }

            /** 
             * Set the 'OtherFulfillmentLocation' element value.
             * 
             * @param otherFulfillmentLocation
             */
            public void setOtherFulfillmentLocation(
                    SrvcLocationAddressType otherFulfillmentLocation) {
                this.otherFulfillmentLocation = otherFulfillmentLocation;
            }
        }
    }
    /** 
     * Flight, Flight Segment and/ or Traveler association(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice maxOccurs="2">
     *       &lt;!-- Reference to inner class AssociationsInner -->
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Associations implements Serializable
    {
        private List<AssociationsInner> associationList = new ArrayList<AssociationsInner>();

        /** 
         * Get the list of 'Associations' element items.
         * 
         * @return list
         */
        public List<AssociationsInner> getAssociationList() {
            return associationList;
        }

        /** 
         * Set the list of 'Associations' element items.
         * 
         * @param list
         */
        public void setAssociationList(List<AssociationsInner> list) {
            associationList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:choice xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="2">
         *   &lt;xs:element ref="ns:SegmentReferences"/>
         *   &lt;xs:element ref="ns:PassengerReferences"/>
         * &lt;/xs:choice>
         * </pre>
         */
        public static class AssociationsInner implements Serializable
        {
            private int associationListSelect = -1;
            private static final int SEGMENT_REFERENCES_CHOICE = 0;
            private static final int PASSENGER_REFERENCES_CHOICE = 1;
            private SegmentReferences segmentReferences;
            private PassengerReferences passengerReferences;

            private void setAssociationListSelect(int choice) {
                if (associationListSelect == -1) {
                    associationListSelect = choice;
                } else if (associationListSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearAssociationListSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearAssociationListSelect() {
                associationListSelect = -1;
            }

            /** 
             * Check if SegmentReferences is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifSegmentReferences() {
                return associationListSelect == SEGMENT_REFERENCES_CHOICE;
            }

            /** 
             * Get the 'SegmentReferences' element value.
             * 
             * @return value
             */
            public SegmentReferences getSegmentReferences() {
                return segmentReferences;
            }

            /** 
             * Set the 'SegmentReferences' element value.
             * 
             * @param segmentReferences
             */
            public void setSegmentReferences(SegmentReferences segmentReferences) {
                setAssociationListSelect(SEGMENT_REFERENCES_CHOICE);
                this.segmentReferences = segmentReferences;
            }

            /** 
             * Check if PassengerReferences is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifPassengerReferences() {
                return associationListSelect == PASSENGER_REFERENCES_CHOICE;
            }

            /** 
             * Get the 'PassengerReferences' element value.
             * 
             * @return value
             */
            public PassengerReferences getPassengerReferences() {
                return passengerReferences;
            }

            /** 
             * Set the 'PassengerReferences' element value.
             * 
             * @param passengerReferences
             */
            public void setPassengerReferences(
                    PassengerReferences passengerReferences) {
                setAssociationListSelect(PASSENGER_REFERENCES_CHOICE);
                this.passengerReferences = passengerReferences;
            }
        }
    }
}
