
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" mixed="true" name="SignatureMethodType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:integer" name="HMACOutputLength" minOccurs="0"/>
 *     &lt;xs:any minOccurs="0" maxOccurs="unbounded" namespace="##other"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="Algorithm"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SignatureMethodType implements Serializable
{
    private BigInteger HMACOutputLength;
    private List<Element> anyList = new ArrayList<Element>();
    private String algorithm;

    /** 
     * Get the 'HMACOutputLength' element value.
     * 
     * @return value
     */
    public BigInteger getHMACOutputLength() {
        return HMACOutputLength;
    }

    /** 
     * Set the 'HMACOutputLength' element value.
     * 
     * @param HMACOutputLength
     */
    public void setHMACOutputLength(BigInteger HMACOutputLength) {
        this.HMACOutputLength = HMACOutputLength;
    }

    /** 
     * Get the list of any items.
     * 
     * @return list
     */
    public List<Element> getAnyList() {
        return anyList;
    }

    /** 
     * Set the list of any items.
     * 
     * @param list
     */
    public void setAnyList(List<Element> list) {
        anyList = list;
    }

    /** 
     * Get the 'Algorithm' attribute value.
     * 
     * @return value
     */
    public String getAlgorithm() {
        return algorithm;
    }

    /** 
     * Set the 'Algorithm' attribute value.
     * 
     * @param algorithm
     */
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }
}
