
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * GENERIC/ IATA SPECIAL SERVICE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Code"/>
 *     &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DescContext" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class SpecialType implements Serializable
{
    private String code;
    private String description;
    private String descContext;
    private String refs;

    /** 
     * Get the 'Code' element value. Special service/ request code value.

    Example: UMNR (IATA passenger assistance SSR code)

    Encoding Scheme: Use of IATA Special Service Request (SSR) Code encoding is recommended. Any string value up to 15 characters in length is valid.

    Note: Although optional in the schema, some SSR codes may require associated description and description codes.
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. Special service/ request code value.

    Example: UMNR (IATA passenger assistance SSR code)

    Encoding Scheme: Use of IATA Special Service Request (SSR) Code encoding is recommended. Any string value up to 15 characters in length is valid.

    Note: Although optional in the schema, some SSR codes may require associated description and description codes.
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'Description' element value. Code description. Example: Unaccompanied Minor
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Code description. Example: Unaccompanied Minor
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'DescContext' element value. Description context. Examples: WEIGHT, NUMBER, PEDICURE
     * 
     * @return value
     */
    public String getDescContext() {
        return descContext;
    }

    /** 
     * Set the 'DescContext' element value. Description context. Examples: WEIGHT, NUMBER, PEDICURE
     * 
     * @param descContext
     */
    public void setDescContext(String descContext) {
        this.descContext = descContext;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
