
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type forService Combination Rule constrained list.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SrvcCombineRuleListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="NotPermitted"/>
 *     &lt;xs:enumeration value="Permitted"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum SrvcCombineRuleListType implements Serializable {
    NOT_PERMITTED("NotPermitted"), PERMITTED("Permitted"), OTHER("Other");
    private final String value;

    private SrvcCombineRuleListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static SrvcCombineRuleListType convert(String value) {
        for (SrvcCombineRuleListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
