
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * TAX CORE representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxCoreType">
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ApproxInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="CollectionInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="RefundAllInd"/>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class TaxCoreType implements Serializable
{
    private Boolean approxInd;
    private Boolean collectionInd;
    private Boolean refundAllInd;
    private String refs;

    /** 
     * Get the 'ApproxInd' attribute value. When true, this tax is approximate.
     * 
     * @return value
     */
    public Boolean getApproxInd() {
        return approxInd;
    }

    /** 
     * Set the 'ApproxInd' attribute value. When true, this tax is approximate.
     * 
     * @param approxInd
     */
    public void setApproxInd(Boolean approxInd) {
        this.approxInd = approxInd;
    }

    /** 
     * Get the 'CollectionInd' attribute value. When true, this tax must be collected.
     * 
     * @return value
     */
    public Boolean getCollectionInd() {
        return collectionInd;
    }

    /** 
     * Set the 'CollectionInd' attribute value. When true, this tax must be collected.
     * 
     * @param collectionInd
     */
    public void setCollectionInd(Boolean collectionInd) {
        this.collectionInd = collectionInd;
    }

    /** 
     * Get the 'RefundAllInd' attribute value. When true, all tax amounts are refundable.
     * 
     * @return value
     */
    public Boolean getRefundAllInd() {
        return refundAllInd;
    }

    /** 
     * Set the 'RefundAllInd' attribute value. When true, all tax amounts are refundable.
     * 
     * @param refundAllInd
     */
    public void setRefundAllInd(Boolean refundAllInd) {
        this.refundAllInd = refundAllInd;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
