
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * TAX DETAIL representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxDetailType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:TaxCoreType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:CurrencyAmountOptType" name="Total" minOccurs="0"/>
 *         &lt;xs:element name="Breakdown" minOccurs="0">
 *           &lt;!-- Reference to inner class Breakdown -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TaxDetailType extends TaxCoreType implements Serializable
{
    private CurrencyAmountOptType total;
    private Breakdown breakdown;

    /** 
     * Get the 'Total' element value. Sub-total of all applicable taxes.  Monetary value and currency code.
     * 
     * @return value
     */
    public CurrencyAmountOptType getTotal() {
        return total;
    }

    /** 
     * Set the 'Total' element value. Sub-total of all applicable taxes.  Monetary value and currency code.
     * 
     * @param total
     */
    public void setTotal(CurrencyAmountOptType total) {
        this.total = total;
    }

    /** 
     * Get the 'Breakdown' element value.
     * 
     * @return value
     */
    public Breakdown getBreakdown() {
        return breakdown;
    }

    /** 
     * Set the 'Breakdown' element value.
     * 
     * @param breakdown
     */
    public void setBreakdown(Breakdown breakdown) {
        this.breakdown = breakdown;
    }
    /** 
     * A collection of detailed taxes.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Breakdown" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Tax" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Tax -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Breakdown implements Serializable
    {
        private List<Tax> taxList = new ArrayList<Tax>();
        private String refs;

        /** 
         * Get the list of 'Tax' element items.
         * 
         * @return list
         */
        public List<Tax> getTaxList() {
            return taxList;
        }

        /** 
         * Set the list of 'Tax' element items.
         * 
         * @param list
         */
        public void setTaxList(List<Tax> list) {
            taxList = list;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
        /** 
         * Tax breakdown detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Qualifier" minOccurs="0"/>
         *       &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount"/>
         *       &lt;xs:element type="xs:string" name="Nation" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="TaxCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="TaxType" minOccurs="0"/>
         *       &lt;xs:element name="CollectionPoint" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class CollectionPoint -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:CurrencyAmountOptType" name="LocalAmount" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
         *       &lt;xs:element name="Conversion" minOccurs="0">
         *         &lt;!-- Reference to inner class Conversion -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:CurrencyAmountOptType" name="FiledAmount" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="FileTaxType" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="AddlTaxType" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="AddlFiledTaxType" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="ApproxInd"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="CollectionInd"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="RefundInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Tax implements Serializable
        {
            private String qualifier;
            private CurrencyAmountOptType amount;
            private String nation;
            private String taxCode;
            private String taxType;
            private List<CollectionPoint> collectionPointList = new ArrayList<CollectionPoint>();
            private CurrencyAmountOptType localAmount;
            private String description;
            private Conversion conversion;
            private CurrencyAmountOptType filedAmount;
            private String fileTaxType;
            private String addlTaxType;
            private String addlFiledTaxType;
            private String refs;
            private Boolean approxInd;
            private Boolean collectionInd;
            private Boolean refundInd;

            /** 
             * Get the 'Qualifier' element value. Indicate whether a tax is paid or new etc. , PADIS codeset, 5305
             * 
             * @return value
             */
            public String getQualifier() {
                return qualifier;
            }

            /** 
             * Set the 'Qualifier' element value. Indicate whether a tax is paid or new etc. , PADIS codeset, 5305
             * 
             * @param qualifier
             */
            public void setQualifier(String qualifier) {
                this.qualifier = qualifier;
            }

            /** 
             * Get the 'Amount' element value. Amount. Example: 15000 USD
             * 
             * @return value
             */
            public CurrencyAmountOptType getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' element value. Amount. Example: 15000 USD
             * 
             * @param amount
             */
            public void setAmount(CurrencyAmountOptType amount) {
                this.amount = amount;
            }

            /** 
             * Get the 'Nation' element value. Tax Nation or Designator. Example: US, GB
             * 
             * @return value
             */
            public String getNation() {
                return nation;
            }

            /** 
             * Set the 'Nation' element value. Tax Nation or Designator. Example: US, GB
             * 
             * @param nation
             */
            public void setNation(String nation) {
                this.nation = nation;
            }

            /** 
             * Get the 'TaxCode' element value. Tax Code. Example: AY, GB
             * 
             * @return value
             */
            public String getTaxCode() {
                return taxCode;
            }

            /** 
             * Set the 'TaxCode' element value. Tax Code. Example: AY, GB
             * 
             * @param taxCode
             */
            public void setTaxCode(String taxCode) {
                this.taxCode = taxCode;
            }

            /** 
             * Get the 'TaxType' element value. Tax type. Used to specify where the tax was applied. May be nice to have for auditing purposes.    Example: 001, 002 
             * 
             * @return value
             */
            public String getTaxType() {
                return taxType;
            }

            /** 
             * Set the 'TaxType' element value. Tax type. Used to specify where the tax was applied. May be nice to have for auditing purposes.    Example: 001, 002 
             * 
             * @param taxType
             */
            public void setTaxType(String taxType) {
                this.taxType = taxType;
            }

            /** 
             * Get the list of 'CollectionPoint' element items.
             * 
             * @return list
             */
            public List<CollectionPoint> getCollectionPointList() {
                return collectionPointList;
            }

            /** 
             * Set the list of 'CollectionPoint' element items.
             * 
             * @param list
             */
            public void setCollectionPointList(List<CollectionPoint> list) {
                collectionPointList = list;
            }

            /** 
             * Get the 'LocalAmount' element value. Local tax amount. Example: 24 CHF
             * 
             * @return value
             */
            public CurrencyAmountOptType getLocalAmount() {
                return localAmount;
            }

            /** 
             * Set the 'LocalAmount' element value. Local tax amount. Example: 24 CHF
             * 
             * @param localAmount
             */
            public void setLocalAmount(CurrencyAmountOptType localAmount) {
                this.localAmount = localAmount;
            }

            /** 
             * Get the 'Description' element value. Tax short description.
            Example: $4 per flight segment, per passenger (U.S. domestic segment tax)
             * 
             * @return value
             */
            public String getDescription() {
                return description;
            }

            /** 
             * Set the 'Description' element value. Tax short description.
            Example: $4 per flight segment, per passenger (U.S. domestic segment tax)
             * 
             * @param description
             */
            public void setDescription(String description) {
                this.description = description;
            }

            /** 
             * Get the 'Conversion' element value.
             * 
             * @return value
             */
            public Conversion getConversion() {
                return conversion;
            }

            /** 
             * Set the 'Conversion' element value.
             * 
             * @param conversion
             */
            public void setConversion(Conversion conversion) {
                this.conversion = conversion;
            }

            /** 
             * Get the 'FiledAmount' element value. The tax filed amount.
             * 
             * @return value
             */
            public CurrencyAmountOptType getFiledAmount() {
                return filedAmount;
            }

            /** 
             * Set the 'FiledAmount' element value. The tax filed amount.
             * 
             * @param filedAmount
             */
            public void setFiledAmount(CurrencyAmountOptType filedAmount) {
                this.filedAmount = filedAmount;
            }

            /** 
             * Get the 'FileTaxType' element value. The filed ticket tax code assigned by IATA..
             * 
             * @return value
             */
            public String getFileTaxType() {
                return fileTaxType;
            }

            /** 
             * Set the 'FileTaxType' element value. The filed ticket tax code assigned by IATA..
             * 
             * @param fileTaxType
             */
            public void setFileTaxType(String fileTaxType) {
                this.fileTaxType = fileTaxType;
            }

            /** 
             * Get the 'AddlTaxType' element value. A qualifier to the Tax Code to distinguish taxes/fees/charges with the same tax code but with different business uses.
             * 
             * @return value
             */
            public String getAddlTaxType() {
                return addlTaxType;
            }

            /** 
             * Set the 'AddlTaxType' element value. A qualifier to the Tax Code to distinguish taxes/fees/charges with the same tax code but with different business uses.
             * 
             * @param addlTaxType
             */
            public void setAddlTaxType(String addlTaxType) {
                this.addlTaxType = addlTaxType;
            }

            /** 
             * Get the 'AddlFiledTaxType' element value. A qualfier to the filed tax code to distinguish taxes/fees/charges with the same tax code but with different business uses.
             * 
             * @return value
             */
            public String getAddlFiledTaxType() {
                return addlFiledTaxType;
            }

            /** 
             * Set the 'AddlFiledTaxType' element value. A qualfier to the filed tax code to distinguish taxes/fees/charges with the same tax code but with different business uses.
             * 
             * @param addlFiledTaxType
             */
            public void setAddlFiledTaxType(String addlFiledTaxType) {
                this.addlFiledTaxType = addlFiledTaxType;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }

            /** 
             * Get the 'ApproxInd' attribute value. When true, this tax is approximate.
             * 
             * @return value
             */
            public Boolean getApproxInd() {
                return approxInd;
            }

            /** 
             * Set the 'ApproxInd' attribute value. When true, this tax is approximate.
             * 
             * @param approxInd
             */
            public void setApproxInd(Boolean approxInd) {
                this.approxInd = approxInd;
            }

            /** 
             * Get the 'CollectionInd' attribute value. When true, this tax must be collected.
             * 
             * @return value
             */
            public Boolean getCollectionInd() {
                return collectionInd;
            }

            /** 
             * Set the 'CollectionInd' attribute value. When true, this tax must be collected.
             * 
             * @param collectionInd
             */
            public void setCollectionInd(Boolean collectionInd) {
                this.collectionInd = collectionInd;
            }

            /** 
             * Get the 'RefundInd' attribute value. When true, this tax amount is refundable.
             * 
             * @return value
             */
            public Boolean getRefundInd() {
                return refundInd;
            }

            /** 
             * Set the 'RefundInd' attribute value. When true, this tax amount is refundable.
             * 
             * @param refundInd
             */
            public void setRefundInd(Boolean refundInd) {
                this.refundInd = refundInd;
            }
            /** 
             * Tax data breakdown by collection point for XF(Passenger Facility Fee) and ZP(federal tax segment) taxes.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CollectionPoint" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:CurrCode" minOccurs="0"/>
             *       &lt;xs:element name="AirportAmount"/>
             *       &lt;xs:element ref="ns:AirportCode"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CollectionPoint implements Serializable
            {
                private CurrCode currCode;
                private AirportCode airportCode;

                /** 
                 * Get the 'CurrCode' element value.
                 * 
                 * @return value
                 */
                public CurrCode getCurrCode() {
                    return currCode;
                }

                /** 
                 * Set the 'CurrCode' element value.
                 * 
                 * @param currCode
                 */
                public void setCurrCode(CurrCode currCode) {
                    this.currCode = currCode;
                }

                /** 
                 * Get the 'AirportCode' element value.
                 * 
                 * @return value
                 */
                public AirportCode getAirportCode() {
                    return airportCode;
                }

                /** 
                 * Set the 'AirportCode' element value.
                 * 
                 * @param airportCode
                 */
                public void setAirportCode(AirportCode airportCode) {
                    this.airportCode = airportCode;
                }
            }
            /** 
             * Amount conversion
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Conversion" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:CurrencyAmount" minOccurs="2" maxOccurs="2"/>
             *       &lt;xs:element type="xs:date" name="ConversionRate"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Conversion implements Serializable
            {
                private List<CurrencyAmount> currencyAmountList = new ArrayList<CurrencyAmount>();
                private Date conversionRate;

                /** 
                 * Get the list of 'CurrencyAmount' element items.
                 * 
                 * @return list
                 */
                public List<CurrencyAmount> getCurrencyAmountList() {
                    return currencyAmountList;
                }

                /** 
                 * Set the list of 'CurrencyAmount' element items.
                 * 
                 * @param list
                 */
                public void setCurrencyAmountList(List<CurrencyAmount> list) {
                    currencyAmountList = list;
                }

                /** 
                 * Get the 'ConversionRate' element value. Define a date of the converion amount
                 * 
                 * @return value
                 */
                public Date getConversionRate() {
                    return conversionRate;
                }

                /** 
                 * Set the 'ConversionRate' element value. Define a date of the converion amount
                 * 
                 * @param conversionRate
                 */
                public void setConversionRate(Date conversionRate) {
                    this.conversionRate = conversionRate;
                }
            }
        }
    }
}
