
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * EXEMPT TAX representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxExemptionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CurrencyAmountOptType" name="Total"/>
 *     &lt;xs:choice>
 *       &lt;xs:sequence>
 *         &lt;!-- Reference to inner class Sequence -->
 *       &lt;/xs:sequence>
 *       &lt;xs:element name="Tax" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Tax -->
 *       &lt;/xs:element>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class TaxExemptionType implements Serializable
{
    private CurrencyAmountOptType total;
    private int choiceSelect = -1;
    private static final int SEQUENCE_CHOICE = 0;
    private static final int TAX_LIST_CHOICE = 1;
    private Sequence sequence;
    private List<Tax> taxList = new ArrayList<Tax>();
    private String refs;

    /** 
     * Get the 'Total' element value. Sub-total of all exempt taxes.  Monetary value and currency code.

     * 
     * @return value
     */
    public CurrencyAmountOptType getTotal() {
        return total;
    }

    /** 
     * Set the 'Total' element value. Sub-total of all exempt taxes.  Monetary value and currency code.

     * 
     * @param total
     */
    public void setTotal(CurrencyAmountOptType total) {
        this.total = total;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Sequence is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSequence() {
        return choiceSelect == SEQUENCE_CHOICE;
    }

    /** 
     * Get the sequence value. Choice between specifying:
    - Summary Exemption Information (Company, Country and/ or Territory Codes)
    - Detailed Exemption Information
     * 
     * @return value
     */
    public Sequence getSequence() {
        return sequence;
    }

    /** 
     * Set the sequence value. Choice between specifying:
    - Summary Exemption Information (Company, Country and/ or Territory Codes)
    - Detailed Exemption Information
     * 
     * @param sequence
     */
    public void setSequence(Sequence sequence) {
        setChoiceSelect(SEQUENCE_CHOICE);
        this.sequence = sequence;
    }

    /** 
     * Check if TaxList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTaxList() {
        return choiceSelect == TAX_LIST_CHOICE;
    }

    /** 
     * Get the list of 'Tax' element items. Choice between specifying:
    - Summary Exemption Information (Company, Country and/ or Territory Codes)
    - Detailed Exemption Information
     * 
     * @return list
     */
    public List<Tax> getTaxList() {
        return taxList;
    }

    /** 
     * Set the list of 'Tax' element items. Choice between specifying:
    - Summary Exemption Information (Company, Country and/ or Territory Codes)
    - Detailed Exemption Information
     * 
     * @param list
     */
    public void setTaxList(List<Tax> list) {
        setChoiceSelect(TAX_LIST_CHOICE);
        taxList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:element name="Entities" minOccurs="0">
     *     &lt;!-- Reference to inner class Entities -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="Territories" minOccurs="0">
     *     &lt;!-- Reference to inner class Territories -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="Countries" minOccurs="0">
     *     &lt;!-- Reference to inner class Countries -->
     *   &lt;/xs:element>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private Entities entities;
        private Territories territories;
        private Countries countries;

        /** 
         * Get the 'Entities' element value.
         * 
         * @return value
         */
        public Entities getEntities() {
            return entities;
        }

        /** 
         * Set the 'Entities' element value.
         * 
         * @param entities
         */
        public void setEntities(Entities entities) {
            this.entities = entities;
        }

        /** 
         * Get the 'Territories' element value.
         * 
         * @return value
         */
        public Territories getTerritories() {
            return territories;
        }

        /** 
         * Set the 'Territories' element value.
         * 
         * @param territories
         */
        public void setTerritories(Territories territories) {
            this.territories = territories;
        }

        /** 
         * Get the 'Countries' element value.
         * 
         * @return value
         */
        public Countries getCountries() {
            return countries;
        }

        /** 
         * Set the 'Countries' element value.
         * 
         * @param countries
         */
        public void setCountries(Countries countries) {
            this.countries = countries;
        }
        /** 
         * Name of entity to which passenger belongs, indicating an exemption to the application of a tax.

        Example: Military, Government
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Entities" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Entity" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Entities implements Serializable
        {
            private List<String> entityList = new ArrayList<String>();

            /** 
             * Get the list of 'Entity' element items. Exempt tax entity name.  Example: Military, IBM
             * 
             * @return list
             */
            public List<String> getEntityList() {
                return entityList;
            }

            /** 
             * Set the list of 'Entity' element items. Exempt tax entity name.  Example: Military, IBM
             * 
             * @param list
             */
            public void setEntityList(List<String> list) {
                entityList = list;
            }
        }
        /** 
         * Name or code of state or territory used to identify tax exemptions.

        Codes are published in Appendix C of IATA AIRIMP.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Territories" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Territory" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Territories implements Serializable
        {
            private List<String> territoryList = new ArrayList<String>();

            /** 
             * Get the list of 'Territory' element items. Exempt tax territory code.  Example: QC
             * 
             * @return list
             */
            public List<String> getTerritoryList() {
                return territoryList;
            }

            /** 
             * Set the list of 'Territory' element items. Exempt tax territory code.  Example: QC
             * 
             * @param list
             */
            public void setTerritoryList(List<String> list) {
                territoryList = list;
            }
        }
        /** 
         * Exempt tax country information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Countries" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:CountryCode" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Countries implements Serializable
        {
            private List<CountryCodeType> countryCodeList = new ArrayList<CountryCodeType>();

            /** 
             * Get the list of 'CountryCode' element items.
             * 
             * @return list
             */
            public List<CountryCodeType> getCountryCodeList() {
                return countryCodeList;
            }

            /** 
             * Set the list of 'CountryCode' element items.
             * 
             * @param list
             */
            public void setCountryCodeList(List<CountryCodeType> list) {
                countryCodeList = list;
            }
        }
    }
    /** 
     * Contains information of all taxes for which passenger is exempt. Includes designator, amount, country code, description etc.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Designator"/>
     *       &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount"/>
     *       &lt;xs:element ref="ns:CountryCode" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Nature" minOccurs="0"/>
     *       &lt;xs:element type="ns:CurrencyAmountOptType" name="LocalAmount" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="ApproxInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="CollectionInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="RefundInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Tax implements Serializable
    {
        private String designator;
        private CurrencyAmountOptType amount;
        private CountryCodeType countryCode;
        private String nature;
        private CurrencyAmountOptType localAmount;
        private String description;
        private String refs;
        private Boolean approxInd;
        private Boolean collectionInd;
        private Boolean refundInd;

        /** 
         * Get the 'Designator' element value. Tax nature. Example: US2
         * 
         * @return value
         */
        public String getDesignator() {
            return designator;
        }

        /** 
         * Set the 'Designator' element value. Tax nature. Example: US2
         * 
         * @param designator
         */
        public void setDesignator(String designator) {
            this.designator = designator;
        }

        /** 
         * Get the 'Amount' element value. Amount. Example: 15000 USD
         * 
         * @return value
         */
        public CurrencyAmountOptType getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' element value. Amount. Example: 15000 USD
         * 
         * @param amount
         */
        public void setAmount(CurrencyAmountOptType amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'CountryCode' element value. Exempt tax country code.  Example: US

        Encoding Scheme: ISO 3166-1 (two character) Country Code
         * 
         * @return value
         */
        public CountryCodeType getCountryCode() {
            return countryCode;
        }

        /** 
         * Set the 'CountryCode' element value. Exempt tax country code.  Example: US

        Encoding Scheme: ISO 3166-1 (two character) Country Code
         * 
         * @param countryCode
         */
        public void setCountryCode(CountryCodeType countryCode) {
            this.countryCode = countryCode;
        }

        /** 
         * Get the 'Nature' element value. Tax nature. Example: US2
         * 
         * @return value
         */
        public String getNature() {
            return nature;
        }

        /** 
         * Set the 'Nature' element value. Tax nature. Example: US2
         * 
         * @param nature
         */
        public void setNature(String nature) {
            this.nature = nature;
        }

        /** 
         * Get the 'LocalAmount' element value. Local tax amount. Example: 24 CHF
         * 
         * @return value
         */
        public CurrencyAmountOptType getLocalAmount() {
            return localAmount;
        }

        /** 
         * Set the 'LocalAmount' element value. Local tax amount. Example: 24 CHF
         * 
         * @param localAmount
         */
        public void setLocalAmount(CurrencyAmountOptType localAmount) {
            this.localAmount = localAmount;
        }

        /** 
         * Get the 'Description' element value. Tax short description.
        Example: $4 per flight segment, per passenger (U.S. domestic segment tax)
         * 
         * @return value
         */
        public String getDescription() {
            return description;
        }

        /** 
         * Set the 'Description' element value. Tax short description.
        Example: $4 per flight segment, per passenger (U.S. domestic segment tax)
         * 
         * @param description
         */
        public void setDescription(String description) {
            this.description = description;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }

        /** 
         * Get the 'ApproxInd' attribute value. When true, this tax is approximate.
         * 
         * @return value
         */
        public Boolean getApproxInd() {
            return approxInd;
        }

        /** 
         * Set the 'ApproxInd' attribute value. When true, this tax is approximate.
         * 
         * @param approxInd
         */
        public void setApproxInd(Boolean approxInd) {
            this.approxInd = approxInd;
        }

        /** 
         * Get the 'CollectionInd' attribute value. When true, this tax must be collected.
         * 
         * @return value
         */
        public Boolean getCollectionInd() {
            return collectionInd;
        }

        /** 
         * Set the 'CollectionInd' attribute value. When true, this tax must be collected.
         * 
         * @param collectionInd
         */
        public void setCollectionInd(Boolean collectionInd) {
            this.collectionInd = collectionInd;
        }

        /** 
         * Get the 'RefundInd' attribute value. When true, this tax amount is refundable.
         * 
         * @return value
         */
        public Boolean getRefundInd() {
            return refundInd;
        }

        /** 
         * Set the 'RefundInd' attribute value. When true, this tax amount is refundable.
         * 
         * @param refundInd
         */
        public void setRefundInd(Boolean refundInd) {
            this.refundInd = refundInd;
        }
    }
}
