
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * AUTO EXCHANGE TICKET object.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketAutoExchangeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Penalty" minOccurs="0">
 *       &lt;!-- Reference to inner class Penalty -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:CurrencyAmountOptType" name="OriginalAmount" minOccurs="0"/>
 *     &lt;xs:element ref="ns:CurrCode" minOccurs="0"/>
 *     &lt;xs:element name="TicketNumbers" minOccurs="0">
 *       &lt;!-- Reference to inner class TicketNumbers -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class TicketAutoExchangeType implements Serializable
{
    private Penalty penalty;
    private CurrencyAmountOptType originalAmount;
    private CurrCode currCode;
    private TicketNumbers ticketNumbers;
    private String refs;

    /** 
     * Get the 'Penalty' element value.
     * 
     * @return value
     */
    public Penalty getPenalty() {
        return penalty;
    }

    /** 
     * Set the 'Penalty' element value.
     * 
     * @param penalty
     */
    public void setPenalty(Penalty penalty) {
        this.penalty = penalty;
    }

    /** 
     * Get the 'OriginalAmount' element value. Total original ticket amount.
    Example: 200 USD
     * 
     * @return value
     */
    public CurrencyAmountOptType getOriginalAmount() {
        return originalAmount;
    }

    /** 
     * Set the 'OriginalAmount' element value. Total original ticket amount.
    Example: 200 USD
     * 
     * @param originalAmount
     */
    public void setOriginalAmount(CurrencyAmountOptType originalAmount) {
        this.originalAmount = originalAmount;
    }

    /** 
     * Get the 'CurrCode' element value.
     * 
     * @return value
     */
    public CurrCode getCurrCode() {
        return currCode;
    }

    /** 
     * Set the 'CurrCode' element value.
     * 
     * @param currCode
     */
    public void setCurrCode(CurrCode currCode) {
        this.currCode = currCode;
    }

    /** 
     * Get the 'TicketNumbers' element value.
     * 
     * @return value
     */
    public TicketNumbers getTicketNumbers() {
        return ticketNumbers;
    }

    /** 
     * Set the 'TicketNumbers' element value.
     * 
     * @param ticketNumbers
     */
    public void setTicketNumbers(TicketNumbers ticketNumbers) {
        this.ticketNumbers = ticketNumbers;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Penalty/ change fee amount and allowable commission amount.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Penalty" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:choice>
     *         &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount"/>
     *         &lt;xs:element type="xs:decimal" name="percentage"/>
     *       &lt;/xs:choice>
     *       &lt;xs:element type="ns:CommissionType" name="Commission" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Penalty implements Serializable
    {
        private int choiceSelect = -1;
        private static final int AMOUNT_CHOICE = 0;
        private static final int PERCENTAGE_CHOICE = 1;
        private CurrencyAmountOptType amount;
        private BigDecimal percentage;
        private CommissionType commission;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Amount is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAmount() {
            return choiceSelect == AMOUNT_CHOICE;
        }

        /** 
         * Get the 'Amount' element value. Commission amount. Example: 20.00 USD
         * 
         * @return value
         */
        public CurrencyAmountOptType getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' element value. Commission amount. Example: 20.00 USD
         * 
         * @param amount
         */
        public void setAmount(CurrencyAmountOptType amount) {
            setChoiceSelect(AMOUNT_CHOICE);
            this.amount = amount;
        }

        /** 
         * Check if Percentage is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPercentage() {
            return choiceSelect == PERCENTAGE_CHOICE;
        }

        /** 
         * Get the 'percentage' element value. Commission percentage. Example: 20
         * 
         * @return value
         */
        public BigDecimal getPercentage() {
            return percentage;
        }

        /** 
         * Set the 'percentage' element value. Commission percentage. Example: 20
         * 
         * @param percentage
         */
        public void setPercentage(BigDecimal percentage) {
            setChoiceSelect(PERCENTAGE_CHOICE);
            this.percentage = percentage;
        }

        /** 
         * Get the 'Commission' element value. Penalty or change fee amount.
        Example: 100 USD
         * 
         * @return value
         */
        public CommissionType getCommission() {
            return commission;
        }

        /** 
         * Set the 'Commission' element value. Penalty or change fee amount.
        Example: 100 USD
         * 
         * @param commission
         */
        public void setCommission(CommissionType commission) {
            this.commission = commission;
        }
    }
    /** 
     * Ticket Number(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketNumbers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="TicketNumber" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class TicketNumber -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TicketNumbers implements Serializable
    {
        private List<TicketNumber> ticketNumberList = new ArrayList<TicketNumber>();

        /** 
         * Get the list of 'TicketNumber' element items.
         * 
         * @return list
         */
        public List<TicketNumber> getTicketNumberList() {
            return ticketNumberList;
        }

        /** 
         * Set the list of 'TicketNumber' element items.
         * 
         * @param list
         */
        public void setTicketNumberList(List<TicketNumber> list) {
            ticketNumberList = list;
        }
        /** 
         * Ticket detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketNumber" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:integer">
         *         &lt;xs:attribute type="xs:string" use="optional" name="PTC"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TicketNumber implements Serializable
        {
            private BigInteger integer;
            private String PTC;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public BigInteger getInteger() {
                return integer;
            }

            /** 
             * Set the extension value.
             * 
             * @param integer
             */
            public void setInteger(BigInteger integer) {
                this.integer = integer;
            }

            /** 
             * Get the 'PTC' attribute value. Passenger type code.
            Example: ADT (ADULT)

            Encoding Scheme: IATA (three character) Passenger Type Code (PTC)
             * 
             * @return value
             */
            public String getPTC() {
                return PTC;
            }

            /** 
             * Set the 'PTC' attribute value. Passenger type code.
            Example: ADT (ADULT)

            Encoding Scheme: IATA (three character) Passenger Type Code (PTC)
             * 
             * @param PTC
             */
            public void setPTC(String PTC) {
                this.PTC = PTC;
            }
        }
    }
}
