
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Ticket document details.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocument">
 *   &lt;xs:complexType>
 *     &lt;xs:complexContent>
 *       &lt;xs:extension base="ns:CouponTicketDocType">
 *         &lt;xs:attribute type="xs:boolean" use="optional" name="PresentCreditCardInd"/>
 *         &lt;xs:attribute type="xs:boolean" use="optional" name="PenaltyRestrictionInd"/>
 *         &lt;xs:attribute type="xs:boolean" use="optional" name="NonCommissionableInd"/>
 *         &lt;xs:attribute type="xs:boolean" use="optional" name="NonInterlineableInd"/>
 *         &lt;xs:attribute type="xs:boolean" use="optional" name="NonReissuableNonExchangInd"/>
 *         &lt;xs:attribute type="xs:boolean" use="optional" name="NonRefundableInd"/>
 *         &lt;xs:attribute type="xs:boolean" use="optional" name="TaxOnEMD_Ind"/>
 *         &lt;xs:attribute type="xs:boolean" use="optional" name="ExchTicketNbrInd"/>
 *         &lt;xs:attribute type="xs:boolean" use="optional" name="PrimaryDocInd"/>
 *       &lt;/xs:extension>
 *     &lt;/xs:complexContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class TicketDocument extends CouponTicketDocType implements Serializable
{
    private Boolean presentCreditCardInd;
    private Boolean penaltyRestrictionInd;
    private Boolean nonCommissionableInd;
    private Boolean nonInterlineableInd;
    private Boolean nonReissuableNonExchangInd;
    private Boolean nonRefundableInd;
    private Boolean taxOnEMDInd;
    private Boolean exchTicketNbrInd;
    private Boolean primaryDocInd;

    /** 
     * Get the 'PresentCreditCardInd' attribute value. When true, the credit/debit card used for purchase must be presented.
     * 
     * @return value
     */
    public Boolean getPresentCreditCardInd() {
        return presentCreditCardInd;
    }

    /** 
     * Set the 'PresentCreditCardInd' attribute value. When true, the credit/debit card used for purchase must be presented.
     * 
     * @param presentCreditCardInd
     */
    public void setPresentCreditCardInd(Boolean presentCreditCardInd) {
        this.presentCreditCardInd = presentCreditCardInd;
    }

    /** 
     * Get the 'PenaltyRestrictionInd' attribute value. When true, a penalty restriction applies.
     * 
     * @return value
     */
    public Boolean getPenaltyRestrictionInd() {
        return penaltyRestrictionInd;
    }

    /** 
     * Set the 'PenaltyRestrictionInd' attribute value. When true, a penalty restriction applies.
     * 
     * @param penaltyRestrictionInd
     */
    public void setPenaltyRestrictionInd(Boolean penaltyRestrictionInd) {
        this.penaltyRestrictionInd = penaltyRestrictionInd;
    }

    /** 
     * Get the 'NonCommissionableInd' attribute value. When true, the document is non-commissionable.
     * 
     * @return value
     */
    public Boolean getNonCommissionableInd() {
        return nonCommissionableInd;
    }

    /** 
     * Set the 'NonCommissionableInd' attribute value. When true, the document is non-commissionable.
     * 
     * @param nonCommissionableInd
     */
    public void setNonCommissionableInd(Boolean nonCommissionableInd) {
        this.nonCommissionableInd = nonCommissionableInd;
    }

    /** 
     * Get the 'NonInterlineableInd' attribute value. When true, the document is non-interlineable.
     * 
     * @return value
     */
    public Boolean getNonInterlineableInd() {
        return nonInterlineableInd;
    }

    /** 
     * Set the 'NonInterlineableInd' attribute value. When true, the document is non-interlineable.
     * 
     * @param nonInterlineableInd
     */
    public void setNonInterlineableInd(Boolean nonInterlineableInd) {
        this.nonInterlineableInd = nonInterlineableInd;
    }

    /** 
     * Get the 'NonReissuableNonExchangInd' attribute value. When true, the document is non reissuable and/or exchangeable.
     * 
     * @return value
     */
    public Boolean getNonReissuableNonExchangInd() {
        return nonReissuableNonExchangInd;
    }

    /** 
     * Set the 'NonReissuableNonExchangInd' attribute value. When true, the document is non reissuable and/or exchangeable.
     * 
     * @param nonReissuableNonExchangInd
     */
    public void setNonReissuableNonExchangInd(Boolean nonReissuableNonExchangInd) {
        this.nonReissuableNonExchangInd = nonReissuableNonExchangInd;
    }

    /** 
     * Get the 'NonRefundableInd' attribute value. When true, the fare is non refundable.
     * 
     * @return value
     */
    public Boolean getNonRefundableInd() {
        return nonRefundableInd;
    }

    /** 
     * Set the 'NonRefundableInd' attribute value. When true, the fare is non refundable.
     * 
     * @param nonRefundableInd
     */
    public void setNonRefundableInd(Boolean nonRefundableInd) {
        this.nonRefundableInd = nonRefundableInd;
    }

    /** 
     * Get the 'TaxOnEMD_Ind' attribute value. When true, a tax has been collected and is due to a local government from the validating carrier.
     * 
     * @return value
     */
    public Boolean getTaxOnEMDInd() {
        return taxOnEMDInd;
    }

    /** 
     * Set the 'TaxOnEMD_Ind' attribute value. When true, a tax has been collected and is due to a local government from the validating carrier.
     * 
     * @param taxOnEMDInd
     */
    public void setTaxOnEMDInd(Boolean taxOnEMDInd) {
        this.taxOnEMDInd = taxOnEMDInd;
    }

    /** 
     * Get the 'ExchTicketNbrInd' attribute value. When true, this is the ticket/document number for a ticket/document that is being exchanged.
     * 
     * @return value
     */
    public Boolean getExchTicketNbrInd() {
        return exchTicketNbrInd;
    }

    /** 
     * Set the 'ExchTicketNbrInd' attribute value. When true, this is the ticket/document number for a ticket/document that is being exchanged.
     * 
     * @param exchTicketNbrInd
     */
    public void setExchTicketNbrInd(Boolean exchTicketNbrInd) {
        this.exchTicketNbrInd = exchTicketNbrInd;
    }

    /** 
     * Get the 'PrimaryDocInd' attribute value. When true, this is the primary ticket/document number. 
     * 
     * @return value
     */
    public Boolean getPrimaryDocInd() {
        return primaryDocInd;
    }

    /** 
     * Set the 'PrimaryDocInd' attribute value. When true, this is the primary ticket/document number. 
     * 
     * @param primaryDocInd
     */
    public void setPrimaryDocInd(Boolean primaryDocInd) {
        this.primaryDocInd = primaryDocInd;
    }
}
