
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * The document number, type and coupon numbers.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocumentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="TicketDocNbr"/>
 *     &lt;xs:element type="xs:string" name="Type"/>
 *     &lt;xs:element name="CpnNbrs" minOccurs="0">
 *       &lt;!-- Reference to inner class CpnNbrs -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TicketDocumentType implements Serializable
{
    private String ticketDocNbr;
    private String type;
    private CpnNbrs cpnNbrs;

    /** 
     * Get the 'TicketDocNbr' element value. The ticket/document number.
     * 
     * @return value
     */
    public String getTicketDocNbr() {
        return ticketDocNbr;
    }

    /** 
     * Set the 'TicketDocNbr' element value. The ticket/document number.
     * 
     * @param ticketDocNbr
     */
    public void setTicketDocNbr(String ticketDocNbr) {
        this.ticketDocNbr = ticketDocNbr;
    }

    /** 
     * Get the 'Type' element value. The type of ticket/document.

    Encoding Scheme: IATA Padis Codeset - List for data element 1001 (Document/ Message Name, coded)
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. The type of ticket/document.

    Encoding Scheme: IATA Padis Codeset - List for data element 1001 (Document/ Message Name, coded)
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'CpnNbrs' element value.
     * 
     * @return value
     */
    public CpnNbrs getCpnNbrs() {
        return cpnNbrs;
    }

    /** 
     * Set the 'CpnNbrs' element value.
     * 
     * @param cpnNbrs
     */
    public void setCpnNbrs(CpnNbrs cpnNbrs) {
        this.cpnNbrs = cpnNbrs;
    }
    /** 
     * Associated Coupon Number(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CpnNbrs" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:integer" name="CpnNbr" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CpnNbrs implements Serializable
    {
        private List<BigInteger> cpnNbrList = new ArrayList<BigInteger>();

        /** 
         * Get the list of 'CpnNbr' element items. Coupon number.
         * 
         * @return list
         */
        public List<BigInteger> getCpnNbrList() {
            return cpnNbrList;
        }

        /** 
         * Set the list of 'CpnNbr' element items. Coupon number.
         * 
         * @param list
         */
        public void setCpnNbrList(List<BigInteger> list) {
            cpnNbrList = list;
        }
    }
}
