
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketIdentificationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Owner" minOccurs="0"/>
 *     &lt;xs:element ref="ns:Security" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="TicketIssueDate"/>
 *     &lt;xs:element type="xs:time" name="TicketIssueTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TicketIssuePlace" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TicketIssueCountry" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DocumentNumber" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjectKeyMetaAttrGroup"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TicketIdentificationType implements Serializable
{
    private boolean owner;
    private SecurityType security;
    private Date ticketIssueDate;
    private Time ticketIssueTime;
    private String ticketIssuePlace;
    private String ticketIssueCountry;
    private String documentNumber;
    private ObjectKeyMetaAttrGroup objectKeyMetaAttrGroup;

    /** 
     * Check if the 'Owner' element is present.
     * 
     * @return <code>true</code> if present, <code>false</code> if not
     */
    public boolean ifOwnerPresent() {
        return owner;
    }

    /** 
     * Set flag for 'Owner' element present.
     * 
     * @param owner
     */
    public void flagOwnerPresent(boolean owner) {
        this.owner = owner;
    }

    /** 
     * Get the 'Security' element value. Contains security details: viewing (display)/booking/sales location(s).
     * 
     * @return value
     */
    public SecurityType getSecurity() {
        return security;
    }

    /** 
     * Set the 'Security' element value. Contains security details: viewing (display)/booking/sales location(s).
     * 
     * @param security
     */
    public void setSecurity(SecurityType security) {
        this.security = security;
    }

    /** 
     * Get the 'TicketIssueDate' element value. Date in ISO 8601 format (yyyy-mm-dd).  Example: 2001-12-25
     * 
     * @return value
     */
    public Date getTicketIssueDate() {
        return ticketIssueDate;
    }

    /** 
     * Set the 'TicketIssueDate' element value. Date in ISO 8601 format (yyyy-mm-dd).  Example: 2001-12-25
     * 
     * @param ticketIssueDate
     */
    public void setTicketIssueDate(Date ticketIssueDate) {
        this.ticketIssueDate = ticketIssueDate;
    }

    /** 
     * Get the 'TicketIssueTime' element value. Time in ISO 8601 format (hh:mm).  Example: 14:00
     * 
     * @return value
     */
    public Time getTicketIssueTime() {
        return ticketIssueTime;
    }

    /** 
     * Set the 'TicketIssueTime' element value. Time in ISO 8601 format (hh:mm).  Example: 14:00
     * 
     * @param ticketIssueTime
     */
    public void setTicketIssueTime(Time ticketIssueTime) {
        this.ticketIssueTime = ticketIssueTime;
    }

    /** 
     * Get the 'TicketIssuePlace' element value. Identifies location where ticket was issued. Normally a 3-letter airport/city code.
     * 
     * @return value
     */
    public String getTicketIssuePlace() {
        return ticketIssuePlace;
    }

    /** 
     * Set the 'TicketIssuePlace' element value. Identifies location where ticket was issued. Normally a 3-letter airport/city code.
     * 
     * @param ticketIssuePlace
     */
    public void setTicketIssuePlace(String ticketIssuePlace) {
        this.ticketIssuePlace = ticketIssuePlace;
    }

    /** 
     * Get the 'TicketIssueCountry' element value. Identifies country where ticket was issued by a two letter country code.
    Example: CA
     * 
     * @return value
     */
    public String getTicketIssueCountry() {
        return ticketIssueCountry;
    }

    /** 
     * Set the 'TicketIssueCountry' element value. Identifies country where ticket was issued by a two letter country code.
    Example: CA
     * 
     * @param ticketIssueCountry
     */
    public void setTicketIssueCountry(String ticketIssueCountry) {
        this.ticketIssueCountry = ticketIssueCountry;
    }

    /** 
     * Get the 'DocumentNumber' element value. Ticket or EMD Number
     * 
     * @return value
     */
    public String getDocumentNumber() {
        return documentNumber;
    }

    /** 
     * Set the 'DocumentNumber' element value. Ticket or EMD Number
     * 
     * @param documentNumber
     */
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    /** 
     * Get the 'ObjectKeyMetaAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public ObjectKeyMetaAttrGroup getObjectKeyMetaAttrGroup() {
        return objectKeyMetaAttrGroup;
    }

    /** 
     * Set the 'ObjectKeyMetaAttrGroup' attributeGroup value.
     * 
     * @param objectKeyMetaAttrGroup
     */
    public void setObjectKeyMetaAttrGroup(
            ObjectKeyMetaAttrGroup objectKeyMetaAttrGroup) {
        this.objectKeyMetaAttrGroup = objectKeyMetaAttrGroup;
    }
}
