
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.Date;

/** 
 * Ticketing Time Limit value.
 Examples: 2017-05-30T09:00:00,  2015-01-13T13:59:38Z

 The time by which passengers must secure tickets (or other accountable documents) for confirmed reservation as agreed with the airline. Passengers meet this requirement by purchasing a ticket (or other accountable document) which indicates the reserved services, or by having previously issued documents revalidated or reissued to reflect the reservation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingTimeLimitType">
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="Timestamp"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class TicketingTimeLimitType implements Serializable
{
    private String refs;
    private Date timestamp;

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'Timestamp' attribute value. Timestamp. Example: 2017-01-13T13:59:38Z
     * 
     * @return value
     */
    public Date getTimestamp() {
        return timestamp;
    }

    /** 
     * Set the 'Timestamp' attribute value. Timestamp. Example: 2017-01-13T13:59:38Z
     * 
     * @param timestamp
     */
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }
}
