
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * TOTAL JOURNEY TIME/ DISTANCE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalJourneyType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Time" minOccurs="0"/>
 *     &lt;xs:element name="Distance" minOccurs="0">
 *       &lt;!-- Reference to inner class Distance -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class TotalJourneyType implements Serializable
{
    private String time;
    private Distance distance;
    private String refs;

    /** 
     * Get the 'Time' element value. Total Journey Time. Example: PT7H45M (7 hours and 45 minutes)

    Note: Total journey time includes the combined air time, connection time and/ or stop information for all specified flight segments.
     * 
     * @return value
     */
    public String getTime() {
        return time;
    }

    /** 
     * Set the 'Time' element value. Total Journey Time. Example: PT7H45M (7 hours and 45 minutes)

    Note: Total journey time includes the combined air time, connection time and/ or stop information for all specified flight segments.
     * 
     * @param time
     */
    public void setTime(String time) {
        this.time = time;
    }

    /** 
     * Get the 'Distance' element value.
     * 
     * @return value
     */
    public Distance getDistance() {
        return distance;
    }

    /** 
     * Set the 'Distance' element value.
     * 
     * @param distance
     */
    public void setDistance(Distance distance) {
        this.distance = distance;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Total Journey distance value and distance unit of measurement.

    Note: Total Journey distance includes the combined distances for all specified flight segments.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Distance" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Value"/>
     *       &lt;xs:element type="xs:string" name="UOM"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Distance implements Serializable
    {
        private String value;
        private String UOM;

        /** 
         * Get the 'Value' element value. Total Flight Distance Value and distance unit of measure. Example: 8,5467
         * 
         * @return value
         */
        public String getValue() {
            return value;
        }

        /** 
         * Set the 'Value' element value. Total Flight Distance Value and distance unit of measure. Example: 8,5467
         * 
         * @param value
         */
        public void setValue(String value) {
            this.value = value;
        }

        /** 
         * Get the 'UOM' element value. Flight Distance Unit of Measure. Examples: Kilometers, Miles
         * 
         * @return value
         */
        public String getUOM() {
            return UOM;
        }

        /** 
         * Set the 'UOM' element value. Flight Distance Unit of Measure. Examples: Kilometers, Miles
         * 
         * @param UOM
         */
        public void setUOM(String UOM) {
            this.UOM = UOM;
        }
    }
}
