
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" mixed="true" name="TransformType">
 *   &lt;xs:choice minOccurs="0" maxOccurs="unbounded">
 *     &lt;!-- Reference to inner class Choice -->
 *   &lt;/xs:choice>
 *   &lt;xs:attribute type="xs:string" use="required" name="Algorithm"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TransformType implements Serializable
{
    private List<Choice> choiceList = new ArrayList<Choice>();
    private String algorithm;

    /** 
     * Get the list of choice items.
     * 
     * @return list
     */
    public List<Choice> getChoiceList() {
        return choiceList;
    }

    /** 
     * Set the list of choice items.
     * 
     * @param list
     */
    public void setChoiceList(List<Choice> list) {
        choiceList = list;
    }

    /** 
     * Get the 'Algorithm' attribute value.
     * 
     * @return value
     */
    public String getAlgorithm() {
        return algorithm;
    }

    /** 
     * Set the 'Algorithm' attribute value.
     * 
     * @param algorithm
     */
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:any processContents="lax" namespace="##other"/>
     *   &lt;xs:element type="xs:string" name="XPath"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceListSelect = -1;
        private static final int ANY_CHOICE = 0;
        private static final int X_PATH_CHOICE = 1;
        private Element any;
        private String XPath;

        private void setChoiceListSelect(int choice) {
            if (choiceListSelect == -1) {
                choiceListSelect = choice;
            } else if (choiceListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceListSelect() {
            choiceListSelect = -1;
        }

        /** 
         * Check if Any is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAny() {
            return choiceListSelect == ANY_CHOICE;
        }

        /** 
         * Get the any value.
         * 
         * @return value
         */
        public Element getAny() {
            return any;
        }

        /** 
         * Set the any value.
         * 
         * @param any
         */
        public void setAny(Element any) {
            setChoiceListSelect(ANY_CHOICE);
            this.any = any;
        }

        /** 
         * Check if XPath is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifXPath() {
            return choiceListSelect == X_PATH_CHOICE;
        }

        /** 
         * Get the 'XPath' element value.
         * 
         * @return value
         */
        public String getXPath() {
            return XPath;
        }

        /** 
         * Set the 'XPath' element value.
         * 
         * @param XPath
         */
        public void setXPath(String XPath) {
            setChoiceListSelect(X_PATH_CHOICE);
            this.XPath = XPath;
        }
    }
}
