
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * A data type for Travel Distance Preference.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelDistancePreferencesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:decimal" name="DistanceAmount"/>
 *     &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="UOM" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class TravelDistancePreferencesType implements Serializable
{
    private BigDecimal distanceAmount;
    private String application;
    private String UOM;
    private PreferenceAttrGroup preferenceAttrGroup;
    private String refs;

    /** 
     * Get the 'DistanceAmount' element value. Travel Distance (unit) Value.  Example: 20
     * 
     * @return value
     */
    public BigDecimal getDistanceAmount() {
        return distanceAmount;
    }

    /** 
     * Set the 'DistanceAmount' element value. Travel Distance (unit) Value.  Example: 20
     * 
     * @param distanceAmount
     */
    public void setDistanceAmount(BigDecimal distanceAmount) {
        this.distanceAmount = distanceAmount;
    }

    /** 
     * Get the 'Application' element value. Travel distance application.
    Examples: TotalJourneyDistance, MaximumTravelDistance
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Travel distance application.
    Examples: TotalJourneyDistance, MaximumTravelDistance
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'UOM' element value. Distance unit of measure.  Example: Kilometers, Miles, Other
     * 
     * @return value
     */
    public String getUOM() {
        return UOM;
    }

    /** 
     * Set the 'UOM' element value. Distance unit of measure.  Example: Kilometers, Miles, Other
     * 
     * @param UOM
     */
    public void setUOM(String UOM) {
        this.UOM = UOM;
    }

    /** 
     * Get the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public PreferenceAttrGroup getPreferenceAttrGroup() {
        return preferenceAttrGroup;
    }

    /** 
     * Set the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @param preferenceAttrGroup
     */
    public void setPreferenceAttrGroup(PreferenceAttrGroup preferenceAttrGroup) {
        this.preferenceAttrGroup = preferenceAttrGroup;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
