
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * A data type for Travel Time Preference.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelTimePreferencesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:decimal" name="TimeAmount"/>
 *     &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
 *   &lt;xs:attribute type="xs:string" name="UOM"/>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class TravelTimePreferencesType implements Serializable
{
    private BigDecimal timeAmount;
    private String application;
    private PreferenceAttrGroup preferenceAttrGroup;
    private String UOM;
    private String refs;

    /** 
     * Get the 'TimeAmount' element value. Travel Distance (unit) Value.  Example: 20
     * 
     * @return value
     */
    public BigDecimal getTimeAmount() {
        return timeAmount;
    }

    /** 
     * Set the 'TimeAmount' element value. Travel Distance (unit) Value.  Example: 20
     * 
     * @param timeAmount
     */
    public void setTimeAmount(BigDecimal timeAmount) {
        this.timeAmount = timeAmount;
    }

    /** 
     * Get the 'Application' element value. Travel time application.
    Examples: TotalJourneyTime, MaximumTravelTime
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Travel time application.
    Examples: TotalJourneyTime, MaximumTravelTime
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public PreferenceAttrGroup getPreferenceAttrGroup() {
        return preferenceAttrGroup;
    }

    /** 
     * Set the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @param preferenceAttrGroup
     */
    public void setPreferenceAttrGroup(PreferenceAttrGroup preferenceAttrGroup) {
        this.preferenceAttrGroup = preferenceAttrGroup;
    }

    /** 
     * Get the 'UOM' attribute value. Travel time unit of measure. Example: Minutes, Hours, days
     * 
     * @return value
     */
    public String getUOM() {
        return UOM;
    }

    /** 
     * Set the 'UOM' attribute value. Travel time unit of measure. Example: Minutes, Hours, days
     * 
     * @param UOM
     */
    public void setUOM(String UOM) {
        this.UOM = UOM;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
