
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * COUPON-RELATED UNSTRUCTURED FARE CALCULATION definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UnstructuredFareCalcType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CouponPurposeListType" name="Purpose" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PricingCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ReportingCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Info" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class UnstructuredFareCalcType implements Serializable
{
    private CouponPurposeListType purpose;
    private String pricingCode;
    private String reportingCode;
    private String info;

    /** 
     * Get the 'Purpose' element value. Unstructured Fare Calculation Purpose. Example: Base, Net, Refund, Sell

    Note: This is used to indicate if this is base or equivalent fare transaction information.
     * 
     * @return value
     */
    public CouponPurposeListType getPurpose() {
        return purpose;
    }

    /** 
     * Set the 'Purpose' element value. Unstructured Fare Calculation Purpose. Example: Base, Net, Refund, Sell

    Note: This is used to indicate if this is base or equivalent fare transaction information.
     * 
     * @param purpose
     */
    public void setPurpose(CouponPurposeListType purpose) {
        this.purpose = purpose;
    }

    /** 
     * Get the 'PricingCode' element value. Pricing Code.

    Note: This is the primary identifier reflecting the method of pricing for this transaction.
     * 
     * @return value
     */
    public String getPricingCode() {
        return pricingCode;
    }

    /** 
     * Set the 'PricingCode' element value. Pricing Code.

    Note: This is the primary identifier reflecting the method of pricing for this transaction.
     * 
     * @param pricingCode
     */
    public void setPricingCode(String pricingCode) {
        this.pricingCode = pricingCode;
    }

    /** 
     * Get the 'ReportingCode' element value. Reporting Code.

    Note: This is a secondary identifier reflecting the method of pricing for this transaction used in the reporting process.
     * 
     * @return value
     */
    public String getReportingCode() {
        return reportingCode;
    }

    /** 
     * Set the 'ReportingCode' element value. Reporting Code.

    Note: This is a secondary identifier reflecting the method of pricing for this transaction used in the reporting process.
     * 
     * @param reportingCode
     */
    public void setReportingCode(String reportingCode) {
        this.reportingCode = reportingCode;
    }

    /** 
     * Get the 'Info' element value. Fare Calculation.

    Note: This is the fare calculation area that is required for ET.
     * 
     * @return value
     */
    public String getInfo() {
        return info;
    }

    /** 
     * Set the 'Info' element value. Fare Calculation.

    Note: This is the fare calculation area that is required for ET.
     * 
     * @param info
     */
    public void setInfo(String info) {
        this.info = info;
    }
}
