
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;

/** 
 * An official entry in a Passport or other Travel Document made by an official of a government to indicate that the bearer has been granted authority to enter or re-enter the country or region concerned.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VisaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="VisaNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="VisaType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="VisaHostCountryCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="EnterBeforeDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="DurationOfStay" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:integer" name="NumberOfEntries" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VisaType implements Serializable
{
    private String visaNumber;
    private String visaType;
    private String visaHostCountryCode;
    private Date enterBeforeDate;
    private BigInteger durationOfStay;
    private BigInteger numberOfEntries;

    /** 
     * Get the 'VisaNumber' element value. Visa ID value. Example: NY122345.
     * 
     * @return value
     */
    public String getVisaNumber() {
        return visaNumber;
    }

    /** 
     * Set the 'VisaNumber' element value. Visa ID value. Example: NY122345.
     * 
     * @param visaNumber
     */
    public void setVisaNumber(String visaNumber) {
        this.visaNumber = visaNumber;
    }

    /** 
     * Get the 'VisaType' element value. The type of visa.
     * 
     * @return value
     */
    public String getVisaType() {
        return visaType;
    }

    /** 
     * Set the 'VisaType' element value. The type of visa.
     * 
     * @param visaType
     */
    public void setVisaType(String visaType) {
        this.visaType = visaType;
    }

    /** 
     * Get the 'VisaHostCountryCode' element value. ISO Country Code where the visa is valid.  For example: DE
     * 
     * @return value
     */
    public String getVisaHostCountryCode() {
        return visaHostCountryCode;
    }

    /** 
     * Set the 'VisaHostCountryCode' element value. ISO Country Code where the visa is valid.  For example: DE
     * 
     * @param visaHostCountryCode
     */
    public void setVisaHostCountryCode(String visaHostCountryCode) {
        this.visaHostCountryCode = visaHostCountryCode;
    }

    /** 
     * Get the 'EnterBeforeDate' element value. Date at which the VISA expires and is no longer a valid entry document.
     * 
     * @return value
     */
    public Date getEnterBeforeDate() {
        return enterBeforeDate;
    }

    /** 
     * Set the 'EnterBeforeDate' element value. Date at which the VISA expires and is no longer a valid entry document.
     * 
     * @param enterBeforeDate
     */
    public void setEnterBeforeDate(Date enterBeforeDate) {
        this.enterBeforeDate = enterBeforeDate;
    }

    /** 
     * Get the 'DurationOfStay' element value. Duration permitted of the Passenger's stay in the visa host country (in days).
     * 
     * @return value
     */
    public BigInteger getDurationOfStay() {
        return durationOfStay;
    }

    /** 
     * Set the 'DurationOfStay' element value. Duration permitted of the Passenger's stay in the visa host country (in days).
     * 
     * @param durationOfStay
     */
    public void setDurationOfStay(BigInteger durationOfStay) {
        this.durationOfStay = durationOfStay;
    }

    /** 
     * Get the 'NumberOfEntries' element value. Number of entries permitted by the visa into the host country.
     * 
     * @return value
     */
    public BigInteger getNumberOfEntries() {
        return numberOfEntries;
    }

    /** 
     * Set the 'NumberOfEntries' element value. Number of entries permitted by the visa into the host country.
     * 
     * @param numberOfEntries
     */
    public void setNumberOfEntries(BigInteger numberOfEntries) {
        this.numberOfEntries = numberOfEntries;
    }
}
