
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Effective/ Expiration Year And Month Date Period Representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="YearMonthPeriodRepType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Effective" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Expiration" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class YearMonthPeriodRepType implements Serializable
{
    private String effective;
    private String expiration;

    /** 
     * Get the 'Effective' element value. Effective (start) year and month.  Example: 2017-01
     * 
     * @return value
     */
    public String getEffective() {
        return effective;
    }

    /** 
     * Set the 'Effective' element value. Effective (start) year and month.  Example: 2017-01
     * 
     * @param effective
     */
    public void setEffective(String effective) {
        this.effective = effective;
    }

    /** 
     * Get the 'Expiration' element value. Expiration (end) year and month.  Example: 2017-12
     * 
     * @return value
     */
    public String getExpiration() {
        return expiration;
    }

    /** 
     * Set the 'Expiration' element value. Expiration (end) year and month.  Example: 2017-12
     * 
     * @param expiration
     */
    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }
}
