package com.gridnine.xtrip.server.ibecorp.tasks.groovy

import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.profile.ModelContractIndex
import com.gridnine.xtrip.common.search.SearchQuery

def query = new SearchQuery()
query.preferredProperties.add('uid')
def es = EntityStorage.get()
def data = new HashSet<String>()
es.search(ModelContractIndex.class, query).data.each {
    def ctr = es.resolve(it.source)

    def allRules = ctr?.entity?.ruleSet?.rules
    def neededRules = allRules?.findAll {
        it.restrictions?.find {
            it.property?.id == "GDS_ACCOUNT" || it.property?.id == "HOTEL_GDS_ACCOUNT"
        }
    }
    if (neededRules){
        data+="${ctr.entity.name} (${ctr.uid}) : ${(neededRules.collect {allRules.indexOf(it)+1}.join(', ') )}"
    }
}
if (!data.isEmpty()) {
    answer.booleanData = true
    answer.textData = data.join(',\r\n')

    //data.each {message(it)}
}
