import com.gridnine.xtrip.common.model.booking.FinanceDocumentType
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.finance.FinanceDocumentData
import com.gridnine.xtrip.common.model.profile.ModelContractIndex
import com.gridnine.xtrip.common.model.rules.finance.Actions
import com.gridnine.xtrip.common.search.SearchQuery

def query = new SearchQuery()
query.preferredProperties.add('uid')
def es = EntityStorage.get()
def uids = new HashSet<String>()
es.search(ModelContractIndex.class, query).data.each {
    def ctr = es.resolve(it.source)
    if (ctr?.entity?.ruleSet?.rules?.findAll {
        it.results?.find {
            it.action == Actions.FINANCE_DOCUMENT_DATA && it.value && it.value instanceof FinanceDocumentData && (it.value as FinanceDocumentData).type == FinanceDocumentType.INVOICE_PREPAYMENT
        }
    }.collect {
        it.results?.find {
            it.action == Actions.FINANCE_DOCUMENT_DATA && it.value && it.value instanceof FinanceDocumentData && (it.value as FinanceDocumentData).type == FinanceDocumentType.INVOICE_PREPAYMENT
        }.value as FinanceDocumentData
    }.collect {
        String.join("|", it.template?.uid, it.billingItemIncludeMode?.name(), it.vatViewMode?.name(),
                Boolean.toString(it.groupByTraveller), Boolean.toString(it.notGroupByProduct),
                it.mergeBillingItems?.toString(), Boolean.toString(it.useDelegate), Boolean.toString(it.useFacsimile),
                it.captionTemplate, Boolean.toString(it.disableCustomerQuotes), Boolean.toString(it.displayContract),
                Boolean.toString(it.notDisplayTitleContractNumber), Boolean.toString(it.notGroupByServiceType),
                Boolean.toString(it.invertSign), Boolean.toString(it.vendorDocument), it.universalDocumentStatus?.name())
    }.unique().size() > 1) {
        uids.add(ctr.uid)
    }
}
if (!uids.isEmpty()) {
    answer.booleanData = true
    answer.textData = uids.join(',')
}
