package com.gridnine.xtrip.server.ibecorp.tasks.groovy.ibecorp7344

import com.gridnine.xtrip.common.model.dict.DictionaryCache
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation
import com.gridnine.xtrip.common.util.MiscUtil
import com.gridnine.xtrip.common.util.TextUtil

doJob()

void doJob() throws Exception {

    Collection<RailwayStation> stations = DictionaryCache.get().getAll(RailwayStation.class).values();

    List<String> invalidStations = new ArrayList<>();

    def total = stations.size()
    def current = 0
    def progr = 0

    for (RailwayStation station : stations){

        if (isToBeStopped()) {
            message("iterator stopped")
            break;
        }

        if (isInvalid(station)){
            invalidStations.add(station.toString())
        }

        def progrNew = Math.round(current * 100d / total)
        if (progr != progrNew) {
            progress("${current + 1} / ${total}".toString(), (int) progrNew)
        }
        progr = progrNew
        current++
    }
    def progrNew = Math.round(current * 100d / total)
    progress("${current} / ${total}".toString(), (int) progrNew)

    message("Обработано ${current} станций")
    message("Невалидные станции: ${invalidStations.size()}")
    message("${invalidStations.toString()}")
}

boolean isInvalid(RailwayStation station){
    def expressCode = station.getCodeVariants().get("EXPRESS")
    def expressUzCode = station.getCodeVariants().get("EXPRESS_UZ")

    boolean isExpressUid = MiscUtil.equals(station.getCode(), expressCode)
    boolean isExpressUzUid = MiscUtil.equals(station.getCode(), expressUzCode)
    boolean isDifferentExpressCodes = TextUtil.nonBlank(expressCode) && TextUtil.nonBlank(expressUzCode) && !MiscUtil.equals(expressCode, expressUzCode)

    return isDifferentExpressCodes || (!isExpressUid && !isExpressUzUid)
}