package com.gridnine.xtrip.server.ibecorp.tasks.groovy.xtr10799

import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.dict.CostCodeCategory
import com.gridnine.xtrip.common.model.dict.DictionaryCache
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.profile.CostCodeProperties
import com.gridnine.xtrip.common.model.profile.Organization
import com.gridnine.xtrip.common.model.profile.OrganizationIndex
import com.gridnine.xtrip.common.model.profile.OrganizationType
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.util.TextUtil
import groovy.transform.Field
import org.apache.commons.lang.time.FastDateFormat

@Field String fileSuffix = FastDateFormat.getInstance("yyyy.MM.dd_HH.mm").format(new Date());
@Field FastDateFormat DTF = FastDateFormat.getInstance("dd.MM.yyyy HH:mm");

@Field boolean onlyLook = true;


if (onlyLook) {
    fileMessage("Режим 'Только просмотр' ");
    fileMessage("");
}
doJob();


void doJob() {
    SearchQuery query = new SearchQuery();
    query.getCriteria()
            .getCriterions()
            .add(SearchCriterion.contains(
                    OrganizationIndex.Property.types.name(), OrganizationType.CORPORATE_CLIENT.name()));


    query.getPreferredProperties().add("containerUid");

    List<OrganizationIndex> organizationIndices =
            EntityStorage.get().search(OrganizationIndex.class, query).getData();
    def current = 0
    def total = organizationIndices.size()
    def progr = 0
    int errors = 0;

    fileMessage("Найдено $total клиентов");

    if (organizationIndices.isEmpty()) {
        return;
    }
    List<String> changedClient = new ArrayList<>();

    for (OrganizationIndex ind : organizationIndices) {
        if (isToBeStopped()) {
            fileMessage("iterator stopped")
            break;
        }
        try {
            EntityContainer<Organization> org = EntityStorage.get().resolve(ind.getSource());
            if (!org.getEntity().getCostCodeProperties().isEmpty()) {
                def iterator = org.getEntity().getCostCodeProperties().iterator();
                boolean found = false;
                while (iterator.hasNext()) {
                    CostCodeProperties costCode = iterator.next();
                    if ("auto-0000001".equals(costCode.getCategory().getCode())) {
                        if (!onlyLook) {
                            iterator.remove();
                        }
                        found = true
                    }
                }
                if (found) {
                    if (!onlyLook){
                        org.getVersionInfo().setDataSource("XTR-10799");
                        org.getVersionInfo().setVersionNotes("Удаление UDID Уполномоченное лицо");
                        EntityStorage.get().save(org, true);
                    }
                    changedClient.add("{" + org.toReference().getUid() + " : " + org.getEntity().code + "}");
                }
            }
        } catch (Exception ex) {
            errors++;
            fileMessage("Ошибка (${ind.name}) : ${TextUtil.getExceptionStackTrace(ex)}", false);
        }

        def progrNew = Math.round(current * 100d / total)
        if (progr != progrNew) {
            progress("${current + 1} / ${total}".toString(), (int) progrNew)
        }
        progr = progrNew
        current++
    }
    def progrNew = Math.round(current * 100d / total)
    progress("${current} / ${total}".toString(), (int) progrNew)

    fileMessage("");
    fileMessage("Возникло ошибок: ${errors}");
    fileMessage("");
    fileMessage("Изменено клиентов: ${changedClient.size()}");
    fileMessage("");
    fileMessage("Список измененных клиентов : Код - ${changedClient.toString()}", false);
}

void fileMessage(String str) {
    fileMessage(str, true)
}

void fileMessage(String str, boolean writeToConsole) {
    if (writeToConsole) {
        message(str);
    }
    new File(Environment.getTempFolder(), "xtr10799${fileSuffix}.txt")
            .append("${DTF.format(new Date())}: ${str} \n");
}