/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.util.HashMap;
import java.util.Map;
import org.jibx.runtime.EnumSet;
import org.jibx.runtime.IAliasable;
import org.jibx.runtime.IMarshaller;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshaller;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class HashMapperStringToSchemaType
implements IMarshaller,
IUnmarshaller,
IAliasable {
    private static final String SIZE_ATTRIBUTE_NAME = "size";
    private static final String ENTRY_ELEMENT_NAME = "entry";
    private static final String KEY_ATTRIBUTE_NAME = "key";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String XSI_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSD_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema";
    private static final String[] SCHEMA_NAMESPACE_URIS = new String[]{"http://www.w3.org/2001/XMLSchema-instance", "http://www.w3.org/2001/XMLSchema"};
    private static final String XSI_NAMESPACE_PREFIX = "xsi";
    private static final String XSD_NAMESPACE_PREFIX = "xsd";
    private static final String[] SCHEMA_NAMESPACE_PREFIXES = new String[]{"xsi", "xsd"};
    private static final String XSD_PREFIX_LEAD = "xsd:";
    private static final int DEFAULT_SIZE = 10;
    public static final int BOOLEAN_TYPE = 0;
    public static final int BYTE_TYPE = 1;
    public static final int DOUBLE_TYPE = 2;
    public static final int FLOAT_TYPE = 3;
    public static final int INT_TYPE = 4;
    public static final int LONG_TYPE = 5;
    public static final int SHORT_TYPE = 6;
    public static final int DATETIME_TYPE = 7;
    public static final int DECIMAL_TYPE = 8;
    public static final int INTEGER_TYPE = 9;
    public static final int BYTERRAY_TYPE = 10;
    public static final int STRING_TYPE = 11;
    public static final int DATE_TYPE = 12;
    public static final int TIME_TYPE = 13;
    private static final EnumSet s_javaTypesEnum = new EnumSet(0, new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.util.Date", "java.math.BigDecimal", "java.math.BigInteger", "byte[]", "java.lang.String", "java.sql.Date", "java.sql.Time"});
    private static final EnumSet s_schemaTypesEnum = new EnumSet(0, new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "dateTime", "decimal", "integer", "base64Binary", "string", "date", "time"});
    private String m_uri;
    private int m_index;
    private String m_name;

    public HashMapperStringToSchemaType() {
        this.m_uri = null;
        this.m_index = 0;
        this.m_name = "hashmap";
    }

    public HashMapperStringToSchemaType(String uri, int index, String name) {
        this.m_uri = uri;
        this.m_index = index;
        this.m_name = name;
    }

    public boolean isExtension(String mapname) {
        return false;
    }

    public void marshal(Object obj, IMarshallingContext ictx) throws JiBXException {
        if (!(obj instanceof Map)) {
            throw new JiBXException("Invalid object type for marshaller");
        }
        if (!(ictx instanceof MarshallingContext)) {
            throw new JiBXException("Invalid object type for marshaller");
        }
        MarshallingContext ctx = (MarshallingContext)ictx;
        IXMLWriter xwrite = ctx.getXmlWriter();
        int ixsi = xwrite.getNamespaces().length;
        String[][] extens = xwrite.getExtensionNamespaces();
        if (extens != null) {
            for (int i = 0; i < extens.length; ++i) {
                ixsi += extens[i].length;
            }
        }
        xwrite.pushExtensionNamespaces(SCHEMA_NAMESPACE_URIS);
        Map map = (Map)obj;
        ctx.startTagNamespaces(this.m_index, this.m_name, new int[]{ixsi, ixsi + 1}, SCHEMA_NAMESPACE_PREFIXES).attribute(this.m_index, SIZE_ATTRIBUTE_NAME, map.size()).closeStartContent();
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            ctx.startTagAttributes(this.m_index, ENTRY_ELEMENT_NAME);
            ctx.attribute(this.m_index, KEY_ATTRIBUTE_NAME, entry.getKey().toString());
            String tname = value.getClass().getName();
            int type = s_javaTypesEnum.getValue(tname);
            if (type < 0) {
                throw new JiBXException("Value of type " + tname + " with key " + entry.getKey() + " is not a supported type");
            }
            ctx.attribute(ixsi, TYPE_ATTRIBUTE_NAME, XSD_PREFIX_LEAD + s_schemaTypesEnum.getName(type));
            ctx.closeStartContent();
            switch (type) {
                case 0: {
                    ctx.content(Utility.serializeBoolean((boolean)((Boolean)value)));
                    break;
                }
                case 1: {
                    ctx.content(Utility.serializeByte((Byte)value));
                    break;
                }
                case 2: {
                    ctx.content(Utility.serializeDouble((Double)value));
                    break;
                }
                case 3: {
                    ctx.content(Utility.serializeFloat(((Float)value).floatValue()));
                    break;
                }
                case 4: {
                    ctx.content((Integer)value);
                    break;
                }
                case 5: {
                    ctx.content(Utility.serializeLong((Long)value));
                    break;
                }
                case 6: {
                    ctx.content(Utility.serializeShort((Short)value));
                    break;
                }
                case 7: {
                    ctx.content(Utility.serializeDateTime((java.util.Date)value));
                    break;
                }
                case 12: {
                    ctx.content(Utility.serializeSqlDate((Date)value));
                    break;
                }
                case 13: {
                    ctx.content(Utility.serializeSqlTime((Time)value));
                    break;
                }
                case 10: {
                    ctx.content(Utility.serializeBase64((byte[])value));
                    break;
                }
                case 8: 
                case 9: 
                case 11: {
                    ctx.content(value.toString());
                }
            }
            ctx.endTag(this.m_index, ENTRY_ELEMENT_NAME);
        }
        ctx.endTag(this.m_index, this.m_name);
        xwrite.popExtensionNamespaces();
    }

    public boolean isPresent(IUnmarshallingContext ctx) throws JiBXException {
        return ctx.isAt(this.m_uri, this.m_name);
    }

    public Object unmarshal(Object obj, IUnmarshallingContext ictx) throws JiBXException {
        UnmarshallingContext ctx = (UnmarshallingContext)ictx;
        if (!ctx.isAt(this.m_uri, this.m_name)) {
            ctx.throwStartTagNameError(this.m_uri, this.m_name);
        }
        int nscnt = ctx.getActiveNamespaceCount();
        String xsdlead = null;
        for (int i = nscnt - 1; i >= 0; --i) {
            String prefix;
            String uri = ctx.getActiveNamespaceUri(i);
            if (!XSD_NAMESPACE_URI.equals(uri) || "".equals(prefix = ctx.getActiveNamespacePrefix(i))) continue;
            xsdlead = prefix + ':';
            break;
        }
        if (xsdlead == null) {
            throw new JiBXException("Missing required schema namespace declaration");
        }
        int size = ctx.attributeInt(this.m_uri, SIZE_ATTRIBUTE_NAME, 10);
        HashMap<String, Object> map = (HashMap<String, Object>)obj;
        if (map == null) {
            map = new HashMap<String, Object>(size);
        }
        ctx.parsePastStartTag(this.m_uri, this.m_name);
        String tdflt = xsdlead + "string";
        while (ctx.isAt(this.m_uri, ENTRY_ELEMENT_NAME)) {
            String key = ctx.attributeText(this.m_uri, KEY_ATTRIBUTE_NAME);
            String tname = ctx.attributeText(XSI_NAMESPACE_URI, TYPE_ATTRIBUTE_NAME, tdflt);
            int type = -1;
            if (tname.startsWith(xsdlead)) {
                type = s_schemaTypesEnum.getValue(tname.substring(xsdlead.length()));
            }
            if (type < 0) {
                throw new JiBXException("Value of type " + tname + " with key " + key + " is not a supported type");
            }
            String text = ctx.parseElementText(this.m_uri, ENTRY_ELEMENT_NAME);
            Object value = null;
            switch (type) {
                case 0: {
                    value = Utility.parseBoolean(text) ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1: {
                    value = new Byte(Utility.parseByte(text));
                    break;
                }
                case 2: {
                    value = new Double(Utility.parseDouble(text));
                    break;
                }
                case 3: {
                    value = new Float(Utility.parseFloat(text));
                    break;
                }
                case 4: {
                    value = new Integer(Utility.parseInt(text));
                    break;
                }
                case 5: {
                    value = new Long(Utility.parseLong(text));
                    break;
                }
                case 6: {
                    value = new Short(Utility.parseShort(text));
                    break;
                }
                case 7: {
                    value = Utility.deserializeDateTime(text);
                    break;
                }
                case 12: {
                    value = Utility.deserializeSqlDate(text);
                    break;
                }
                case 13: {
                    value = Utility.deserializeSqlTime(text);
                    break;
                }
                case 10: {
                    value = Utility.deserializeBase64(text);
                    break;
                }
                case 8: {
                    value = new BigDecimal(text);
                    break;
                }
                case 9: {
                    value = new BigInteger(text);
                    break;
                }
                case 11: {
                    value = text;
                }
            }
            map.put(key, value);
        }
        ctx.parsePastEndTag(this.m_uri, this.m_name);
        return map;
    }
}

