/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime;

public final class WhitespaceConversions {
    private WhitespaceConversions() {
    }

    private static String convertReplaced(String text, int index) {
        int length = text.length();
        StringBuffer buff = new StringBuffer(length - 1);
        for (int i = 0; i < index; ++i) {
            buff.append(text.charAt(i));
        }
        block4: while (index < length) {
            char chr = text.charAt(index++);
            switch (chr) {
                case '\t': 
                case '\n': 
                case '\r': {
                    buff.append(' ');
                    continue block4;
                }
            }
            buff.append(chr);
        }
        return buff.toString();
    }

    public static String replace(String text) {
        int index;
        if (text == null) {
            return null;
        }
        int length = text.length();
        block3: for (index = 0; index < length; ++index) {
            switch (text.charAt(index)) {
                case '\t': 
                case '\n': 
                case '\r': {
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        if (index < length) {
            return WhitespaceConversions.convertReplaced(text, index);
        }
        return text;
    }

    private static String convertCollapsed(String text, int index) {
        int length = text.length();
        StringBuffer buff = new StringBuffer(length - 1);
        if (index > 0) {
            for (int i = 0; i < index; ++i) {
                buff.append(text.charAt(i));
            }
            buff.append(' ');
        }
        boolean drop = true;
        block4: while (++index < length) {
            char chr = text.charAt(index);
            switch (chr) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (drop) continue block4;
                    buff.append(' ');
                    drop = true;
                    continue block4;
                }
            }
            buff.append(chr);
            drop = false;
        }
        if (drop && buff.length() > 0) {
            buff.setLength(buff.length() - 1);
        }
        return buff.toString();
    }

    public static String collapse(String text) {
        int index;
        if (text == null) {
            return null;
        }
        int length = text.length();
        block3: for (index = 0; index < length; ++index) {
            switch (text.charAt(index)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        if (index < length) {
            return WhitespaceConversions.convertCollapsed(text, index);
        }
        return text;
    }

    public static String trim(String text) {
        int start;
        if (text == null) {
            return null;
        }
        int length = text.length();
        block6: for (start = 0; start < length; ++start) {
            switch (text.charAt(start)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block6;
                }
            }
        }
        if (start < length) {
            int end = length - 1;
            block7: while (true) {
                switch (text.charAt(end)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        break block7;
                    }
                }
                --end;
            }
            if (start > 0 || ++end < length) {
                return text.substring(start, end);
            }
            return text;
        }
        return "";
    }
}

