/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.IXMLReaderFactory;
import org.jibx.runtime.impl.InByteBuffer;
import org.jibx.runtime.impl.InputStreamWrapper;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XMLPullReaderFactory
implements IXMLReaderFactory {
    private static final String DEFAULT_PARSER_NAME = "org.xmlpull.mxp1.MXParserFactory";
    private static final XMLPullReaderFactory s_instance;
    private final XmlPullParserFactory m_factory;

    private XMLPullReaderFactory(XmlPullParserFactory factory) {
        this.m_factory = factory;
    }

    public static XMLPullReaderFactory getInstance() {
        return s_instance;
    }

    private XmlPullParser createParser(boolean nsf) throws XmlPullParserException {
        XmlPullParser parser = this.m_factory.newPullParser();
        if (nsf) {
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        }
        return parser;
    }

    public IXMLReader createReader(InputStream is, String name, String enc, boolean nsf) throws JiBXException {
        try {
            return this.recycleReader(new XMLPullReader(this.createParser(nsf)), is, name, enc);
        }
        catch (XmlPullParserException e) {
            throw new JiBXException("Error creating parser", e);
        }
    }

    public IXMLReader createReader(Reader rdr, String name, boolean nsf) throws JiBXException {
        try {
            return this.recycleReader(new XMLPullReader(this.createParser(nsf)), rdr, name);
        }
        catch (XmlPullParserException e) {
            throw new JiBXException("Error creating parser", e);
        }
    }

    public IXMLReader recycleReader(IXMLReader old, InputStream is, String name, String enc) throws JiBXException {
        ((XMLPullReader)old).setDocument(is, name, enc);
        return old;
    }

    public IXMLReader recycleReader(IXMLReader old, Reader rdr, String name) throws JiBXException {
        ((XMLPullReader)old).setDocument(rdr, name);
        return old;
    }

    static {
        XmlPullParserFactory factory = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = XMLPullReaderFactory.class.getClassLoader();
        }
        try {
            String name = System.getProperty("org.xmlpull.v1.XmlPullParserFactory");
            if (name != null && (name = name.trim()).length() > 0) {
                factory = XmlPullParserFactory.newInstance((String)name, loader.getClass());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (factory == null) {
            try {
                factory = XmlPullParserFactory.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (factory == null) {
                throw new RuntimeException("Unable to create XMLPull parser");
            }
        }
        s_instance = new XMLPullReaderFactory(factory);
    }

    private static class XMLPullReader
    implements IXMLReader {
        private final XmlPullParser m_parser;
        private String m_docName;
        private InByteBuffer m_byteBuffer;
        private InputStreamWrapper m_streamWrapper;
        private String m_encoding;

        private XMLPullReader(XmlPullParser parser) {
            this.m_parser = parser;
        }

        private void setDocument(InputStream is, String name, String enc) throws JiBXException {
            try {
                if (enc == null) {
                    if (this.m_streamWrapper == null) {
                        this.m_streamWrapper = new InputStreamWrapper();
                        this.m_byteBuffer = new InByteBuffer();
                        this.m_streamWrapper.setBuffer(this.m_byteBuffer);
                    } else {
                        this.m_streamWrapper.reset();
                    }
                    this.m_byteBuffer.setInput(is);
                    this.setDocument(this.m_streamWrapper.getReader(), name);
                    this.m_encoding = this.m_streamWrapper.getEncoding();
                } else {
                    this.m_docName = name;
                    this.m_encoding = enc;
                    this.m_parser.setInput(is, enc);
                }
            }
            catch (XmlPullParserException e) {
                throw new JiBXException("Error initializing parser", e);
            }
            catch (IOException e) {
                throw new JiBXException("Error reading from stream", e);
            }
        }

        private void setDocument(Reader rdr, String name) throws JiBXException {
            try {
                this.m_docName = name;
                this.m_encoding = null;
                this.m_parser.setInput(rdr);
            }
            catch (XmlPullParserException e) {
                throw new JiBXException("Error initializing parser", e);
            }
        }

        private String describeException(Exception e) {
            return "Error parsing document " + this.buildPositionString() + ": " + e.getMessage();
        }

        public void init() {
        }

        public String buildPositionString() {
            String base = "(line " + this.m_parser.getLineNumber() + ", col " + this.m_parser.getColumnNumber();
            if (this.m_docName != null) {
                base = base + ", in " + this.m_docName;
            }
            return base + ')';
        }

        public int nextToken() throws JiBXException {
            try {
                return this.m_parser.nextToken();
            }
            catch (IOException e) {
                throw new JiBXException("Error accessing document", e);
            }
            catch (XmlPullParserException e) {
                throw new JiBXException("Error parsing document " + this.buildPositionString(), e);
            }
        }

        public int next() throws JiBXException {
            try {
                return this.m_parser.next();
            }
            catch (IOException e) {
                throw new JiBXException("Error accessing document", e);
            }
            catch (XmlPullParserException e) {
                throw new JiBXException("Error parsing document " + this.buildPositionString(), e);
            }
        }

        public int getEventType() throws JiBXException {
            try {
                return this.m_parser.getEventType();
            }
            catch (XmlPullParserException e) {
                throw new JiBXException("Error parsing document " + this.buildPositionString(), e);
            }
        }

        public String getName() {
            String name = this.m_parser.getName();
            if (name == null) {
                throw new IllegalStateException("Internal state error: not at start or end tag");
            }
            return name;
        }

        public String getNamespace() {
            String uri = this.m_parser.getNamespace();
            if (uri == null) {
                throw new IllegalStateException("Internal state error: not at start or end tag");
            }
            return uri;
        }

        public String getPrefix() {
            return this.m_parser.getPrefix();
        }

        public int getAttributeCount() {
            int count = this.m_parser.getAttributeCount();
            if (count < 0) {
                throw new IllegalStateException("Internal state error: not at start tag");
            }
            return count;
        }

        public String getAttributeName(int index) {
            try {
                return this.m_parser.getAttributeName(index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalStateException(this.describeException(e));
            }
        }

        public String getAttributeNamespace(int index) {
            try {
                return this.m_parser.getAttributeNamespace(index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalStateException(this.describeException(e));
            }
        }

        public String getAttributePrefix(int index) {
            try {
                return this.m_parser.getAttributePrefix(index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalStateException(this.describeException(e));
            }
        }

        public String getAttributeValue(int index) {
            try {
                return this.m_parser.getAttributeValue(index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalStateException(this.describeException(e));
            }
        }

        public String getAttributeValue(String ns, String name) {
            try {
                return this.m_parser.getAttributeValue(ns, name);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalStateException(this.describeException(e));
            }
        }

        public String getText() {
            return this.m_parser.getText();
        }

        public int getNestingDepth() {
            return this.m_parser.getDepth();
        }

        public int getNamespaceCount(int depth) {
            try {
                return this.m_parser.getNamespaceCount(depth);
            }
            catch (XmlPullParserException e) {
                throw new IllegalArgumentException(this.describeException((Exception)((Object)e)));
            }
        }

        public String getNamespaceUri(int index) {
            try {
                return this.m_parser.getNamespaceUri(index);
            }
            catch (XmlPullParserException e) {
                throw new IllegalArgumentException(this.describeException((Exception)((Object)e)));
            }
        }

        public String getNamespacePrefix(int index) {
            try {
                return this.m_parser.getNamespacePrefix(index);
            }
            catch (XmlPullParserException e) {
                throw new IllegalArgumentException(this.describeException((Exception)((Object)e)));
            }
        }

        public String getDocumentName() {
            return this.m_docName;
        }

        public int getLineNumber() {
            return this.m_parser.getLineNumber();
        }

        public int getColumnNumber() {
            return this.m_parser.getColumnNumber();
        }

        public String getNamespace(String prefix) {
            return this.m_parser.getNamespace(prefix);
        }

        public String getInputEncoding() {
            return this.m_encoding;
        }

        public boolean isNamespaceAware() {
            return this.m_parser.getFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces");
        }
    }
}

