/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.codec;

import java.io.IOException;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.impl.IInByteBuffer;
import org.jibx.runtime.impl.IOutByteBuffer;
import org.jibx.ws.codec.CodecFactory;
import org.jibx.ws.codec.MediaType;
import org.jibx.ws.codec.XmlCodec;
import org.xbis.JibxReader;
import org.xbis.JibxWriter;

public final class XbisCodecFactory
implements CodecFactory {
    public XmlCodec createInstance(MediaType mediaType) {
        return new XbisCodec(mediaType);
    }

    private static final class XbisCodec
    implements XmlCodec {
        private final MediaType m_mediaType;
        private JibxWriter m_writer;
        private JibxReader m_reader;

        public XbisCodec(MediaType mediaType) {
            this.m_mediaType = mediaType;
        }

        public MediaType getMediaType() {
            return this.m_mediaType;
        }

        public IXMLWriter getWriter(IOutByteBuffer buff, String charcode, String[] uris) throws IOException {
            if (this.m_writer == null) {
                this.m_writer = new JibxWriter(uris, buff);
            } else {
                this.m_writer.setNamespaceUris(uris);
                this.m_writer.setBuffer(buff);
            }
            return this.m_writer;
        }

        public IXMLReader getReader(IInByteBuffer buff, String charcode, String name, boolean reset) throws IOException {
            if (this.m_reader == null) {
                this.m_reader = new JibxReader(buff);
            } else {
                this.m_reader.setBuffer(buff);
            }
            if (reset) {
                this.m_reader.reset();
            }
            return this.m_reader;
        }
    }
}

