/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Context {
    private static final Log logger = LogFactory.getLog(Context.class);
    private final Map m_attributes = new HashMap();

    public final Object getAttribute(String name) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting attribute " + name));
        }
        return this.m_attributes.get(name);
    }

    public final Set getAttributeNames() {
        return this.m_attributes.keySet();
    }

    public final void removeAttribute(String name) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing attribute " + name));
        }
        this.m_attributes.remove(name);
    }

    public final void setAttribute(String name, Object value) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting attribute " + name + " to " + value));
        }
        this.m_attributes.put(name, value);
    }

    public void reset() {
        logger.debug((Object)"Resetting attributes");
        this.m_attributes.clear();
    }
}

