/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jibx.runtime.IXMLReader;
import org.jibx.ws.WsException;
import org.jibx.ws.context.MessageContext;
import org.jibx.ws.context.Phase;
import org.jibx.ws.io.PayloadReader;
import org.jibx.ws.io.handler.InHandler;

public final class InContext
extends MessageContext {
    private PayloadReader m_bodyReader;
    private Map m_handlersByPhase;

    public void setBodyReader(PayloadReader bodyReader) {
        this.m_bodyReader = bodyReader;
    }

    public void invokeBodyReader(IXMLReader xmlReader) throws IOException, WsException {
        if (this.m_bodyReader != null) {
            Object body = this.m_bodyReader.invoke(xmlReader);
            this.setBody(body);
        }
    }

    public void addHandler(Phase phase, InHandler handler) {
        if (handler != null) {
            ArrayList<InHandler> handlers;
            if (this.m_handlersByPhase == null) {
                this.m_handlersByPhase = new HashMap();
            }
            if ((handlers = (ArrayList<InHandler>)this.m_handlersByPhase.get(phase)) == null) {
                handlers = new ArrayList<InHandler>();
                this.m_handlersByPhase.put(phase, handlers);
            }
            handlers.add(handler);
        }
    }

    public boolean hasHandlers(Phase phase) {
        if (this.m_handlersByPhase == null) {
            return false;
        }
        ArrayList handlers = (ArrayList)this.m_handlersByPhase.get(phase);
        return handlers != null && handlers.size() > 0;
    }

    public Object invokeInHandlers(Phase phase, IXMLReader xmlReader) throws IOException, WsException {
        if (this.m_handlersByPhase == null) {
            return null;
        }
        ArrayList handlers = (ArrayList)this.m_handlersByPhase.get(phase);
        if (handlers != null) {
            for (int i = 0; i < handlers.size(); ++i) {
                InHandler handler = (InHandler)handlers.get(i);
                Object obj = handler.invoke(this, xmlReader);
                if (obj == null) continue;
                return obj;
            }
        }
        return null;
    }

    public boolean isOutbound() {
        return false;
    }

    public void reset() {
        super.reset();
        this.m_bodyReader.reset();
    }
}

