/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.encoding.dime;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.runtime.impl.IOutByteBuffer;
import org.jibx.ws.encoding.dime.DimeCommon;

public class DimeOutputBuffer
implements IOutByteBuffer {
    private static final Log s_logger = LogFactory.getLog(DimeOutputBuffer.class);
    private IOutByteBuffer m_byteBuffer;
    private byte[] m_buffer;
    private int m_headerSize;
    private int m_base;
    private int m_offset;
    private int m_messageState = 3;
    private boolean m_ended;

    public void setBuffer(IOutByteBuffer buff) {
        if (this.m_byteBuffer != null && this.m_byteBuffer != buff) {
            try {
                this.m_byteBuffer.finish();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_byteBuffer = buff;
        this.m_buffer = buff.getBuffer();
        this.m_offset = this.m_base = buff.getOffset();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Set buffer to instance of " + buff.getClass().getName() + " with base " + this.m_offset));
        }
    }

    public void nextMessage() {
        if (this.m_messageState != 3) {
            throw new IllegalStateException("Internal error - cannot start message until previous message finished");
        }
        this.m_messageState = 0;
        this.m_ended = false;
        s_logger.debug((Object)"Advanced to next message");
    }

    public void nextPart(String id, int typecode, String type) {
        if (this.m_messageState == 3) {
            throw new IllegalStateException("Internal error - cannot start part after message finished");
        }
        if (this.m_messageState == 2) {
            throw new IllegalStateException("Internal error - cannot start part until last record finished");
        }
        this.m_offset = this.initFirstHeader(id, typecode, type);
        s_logger.debug((Object)"Advanced to next record");
    }

    private void fillShort(int offset, int value) {
        this.m_buffer[offset + 1] = (byte)value;
        this.m_buffer[offset] = (byte)(value >> 8);
    }

    private int fillString(int offset, String text) {
        if (text != null && text.length() > 0) {
            try {
                byte[] byts = text.getBytes("UTF-8");
                System.arraycopy(byts, 0, this.m_buffer, offset, byts.length);
                offset += byts.length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return offset;
    }

    private int fillPadding(int offset) {
        while ((offset - this.m_base & 3) != 0) {
            this.m_buffer[offset++] = 0;
        }
        return offset;
    }

    private int initFirstHeader(String id, int typecode, String type) {
        int offset = this.m_base + 12;
        switch (this.m_messageState) {
            case 0: 
            case 1: {
                this.m_buffer[this.m_base + 1] = (byte)typecode;
                int fill = this.fillString(offset, id);
                this.fillShort(this.m_base + 4, fill - offset);
                offset = this.fillPadding(fill);
                fill = this.fillString(offset, type);
                this.fillShort(this.m_base + 6, fill - offset);
                offset = this.fillPadding(fill);
                break;
            }
            default: {
                throw new IllegalStateException("Internal error - not in valid header state");
            }
        }
        this.m_headerSize = offset;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Initialized new record header ending at offset " + offset + " with id " + id + ", typecode " + typecode + ", type " + type));
        }
        return offset;
    }

    private int initFollowHeader() {
        for (int i = 1; i < 12; ++i) {
            this.m_buffer[this.m_base + i] = 0;
        }
        this.m_headerSize = this.m_base + 12;
        int offset = this.m_base + this.m_headerSize;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Initialized chunk record header ending at offset " + offset));
        }
        return offset;
    }

    private void finishHeader(int length, boolean last, boolean end) {
        int byt = 8;
        if (this.m_messageState == 0) {
            byt |= 4;
            this.m_messageState = 1;
        } else if (this.m_messageState == 3) {
            throw new IllegalStateException("Internal error - cannot write after message finished");
        }
        if (last) {
            if (end) {
                byt |= 2;
            }
        } else {
            byt |= 1;
        }
        this.m_buffer[this.m_base] = (byte)byt;
        this.fillShort(this.m_base + 8, length >> 16);
        this.fillShort(this.m_base + 10, length);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Finished header:" + DimeCommon.dumpBytes(this.m_buffer, 0, this.m_headerSize)));
        }
        this.m_headerSize = 0;
    }

    private void createChunk(boolean last, boolean end) throws IOException {
        int length = this.m_offset - this.m_base;
        this.finishHeader(length - this.m_headerSize, last, end);
        int total = this.fillPadding(length);
        this.m_offset = this.m_base + total;
        this.m_byteBuffer.setOffset(this.m_offset);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Created chunk of length " + total));
        }
        this.m_messageState = last ? (end ? 3 : 1) : 2;
    }

    public void endMessage() throws IOException {
        s_logger.debug((Object)"Ending message");
        this.m_ended = true;
    }

    public byte[] getBuffer() {
        return this.m_buffer;
    }

    public int getOffset() {
        return this.m_offset;
    }

    public void setOffset(int offset) {
        this.m_offset = offset;
    }

    public void free(int reserve, int size) throws IOException {
        if (this.m_buffer.length - this.m_offset < size) {
            int adjsize = size + 12 + 3 & 0xFFFFFFFC;
            if (reserve >= this.m_offset) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Creating chunk of size " + size));
                }
                this.createChunk(false, false);
                this.m_byteBuffer.free(this.m_offset, adjsize);
                this.m_buffer = this.m_byteBuffer.getBuffer();
                this.m_base = this.m_byteBuffer.getOffset();
                this.m_offset = this.initFollowHeader();
            } else if (reserve > 16384) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Copying to free " + size + " with offset " + this.m_offset + " and reserve " + reserve));
                }
                int keep = this.m_offset - reserve;
                byte[] byts = new byte[keep];
                System.arraycopy(this.m_buffer, reserve, byts, 0, keep);
                this.m_offset = reserve;
                this.createChunk(false, false);
                this.m_byteBuffer.free(this.m_offset, adjsize);
                this.m_buffer = this.m_byteBuffer.getBuffer();
                this.m_base = this.m_byteBuffer.getOffset();
                this.m_offset = this.initFollowHeader();
                System.arraycopy(byts, 0, this.m_buffer, this.m_offset, keep);
                this.m_offset += keep;
            } else {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Resizing to free " + size + " with offset " + this.m_offset + " and reserve " + reserve));
                }
                this.m_byteBuffer.setOffset(this.m_offset);
                this.m_byteBuffer.free(0, adjsize);
                this.m_buffer = this.m_byteBuffer.getBuffer();
            }
        }
    }

    public void flush() throws IOException {
        s_logger.debug((Object)"Flushing output");
        if (this.m_messageState != 3) {
            if (this.m_headerSize == 0) {
                this.nextPart(null, 64, null);
            }
            this.createChunk(true, this.m_ended);
        }
        this.m_byteBuffer.flush();
    }

    public void finish() throws IOException {
        this.endMessage();
        this.flush();
        this.m_byteBuffer.finish();
    }
}

