/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.http.client.apache;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.Args;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.impl.IInByteBuffer;
import org.jibx.runtime.impl.IOutByteBuffer;
import org.jibx.runtime.impl.InByteBuffer;
import org.jibx.runtime.impl.OutByteBuffer;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.WsException;
import org.jibx.ws.codec.CodecCache;
import org.jibx.ws.codec.CodecDirectory;
import org.jibx.ws.codec.EncodingCodec;
import org.jibx.ws.codec.EncodingCodecCache;
import org.jibx.ws.codec.MediaType;
import org.jibx.ws.http.client.Basic;
import org.jibx.ws.http.client.Credentials;
import org.jibx.ws.http.client.HttpInConnection;
import org.jibx.ws.http.client.HttpInputStreamInterceptor;
import org.jibx.ws.http.client.HttpOutConnection;
import org.jibx.ws.http.client.HttpOutputStreamInterceptor;
import org.jibx.ws.http.client.HttpTransportOptions;
import org.jibx.ws.http.client.NTLM;
import org.jibx.ws.io.XmlOptions;
import org.jibx.ws.transport.Channel;
import org.jibx.ws.transport.DuplexConnection;
import org.jibx.ws.transport.InConnection;
import org.jibx.ws.transport.MessageProperties;
import org.jibx.ws.transport.OutConnection;
import org.jibx.ws.transport.OutConnectionBase;
import org.jibx.ws.transport.SimpleDuplexConnection;
import org.jibx.ws.transport.StreamBufferInPool;
import org.jibx.ws.transport.StreamBufferOutPool;
import org.jibx.ws.transport.interceptor.InputStreamInterceptor;
import org.jibx.ws.transport.interceptor.OutputStreamInterceptor;

public final class HttpChannel
implements Channel {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CHARSET_KEY = "charset";
    private static final String ACTION_KEY = "action";
    private static final String ACCEPT_TYPE = "Accept";
    private static final String ACCEPT_ENCODING_TYPE = "Accept-Encoding";
    private static final int BUFFER_SIZE = 8192;
    private final URL m_url;
    private final CodecCache m_codecCache;
    private final EncodingCodecCache m_encodingCodecCache;
    private final StreamBufferInPool m_inBufferCache;
    private final StreamBufferOutPool m_outBufferCache;
    private HttpTransportOptions m_transportOptions;

    public HttpChannel(URL url, HttpTransportOptions transportOptions) {
        this.m_url = url;
        this.m_transportOptions = transportOptions;
        this.m_codecCache = new CodecCache();
        this.m_encodingCodecCache = new EncodingCodecCache();
        this.m_inBufferCache = new StreamBufferInPool(8192);
        this.m_outBufferCache = new StreamBufferOutPool(8192);
    }

    private CloseableHttpClient getHttpClient(final HttpOutConnectionInstance outConnection, final HttpInConnectionInstance inConnection) {
        SSLContext sslContext;
        HostnameVerifier SSLHostnameVerifier;
        HttpClientBuilder builder = HttpClients.custom();
        if (outConnection != null) {
            RequestConfig.Builder rcb = RequestConfig.custom();
            if (this.m_transportOptions.getConnectTimeout() != null) {
                rcb.setConnectTimeout(this.m_transportOptions.getConnectTimeout().intValue());
            }
            if (this.m_transportOptions.getReadTimeout() != null) {
                rcb.setSocketTimeout(this.m_transportOptions.getReadTimeout().intValue());
            }
            builder.setDefaultRequestConfig(rcb.build());
            builder.addInterceptorFirst(new HttpRequestInterceptor(){

                public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                    outConnection.first(request);
                }
            });
            builder.addInterceptorLast(new HttpRequestInterceptor(){

                public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                    outConnection.last();
                }
            });
        }
        if (inConnection != null) {
            builder.addInterceptorFirst(new HttpResponseInterceptor(){

                public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                    inConnection.first(response);
                }
            });
        }
        if (null == (SSLHostnameVerifier = this.m_transportOptions.getSSLHostnameVerifier())) {
            SSLHostnameVerifier = new DefaultHostnameVerifier(PublicSuffixMatcherLoader.getDefault());
        }
        if ((sslContext = this.m_transportOptions.getSslContext()) != null) {
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext, this.m_transportOptions.getSslSupportedProtocols(), null, SSLHostnameVerifier));
        } else {
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(SSLContexts.createDefault(), SSLHostnameVerifier));
        }
        Credentials credentials = this.m_transportOptions.getCredentials();
        if (credentials != null) {
            BasicCredentialsProvider cp = new BasicCredentialsProvider();
            if (credentials instanceof NTLM) {
                NTLM ntlm = (NTLM)credentials;
                cp.setCredentials(AuthScope.ANY, (org.apache.http.auth.Credentials)new NTCredentials(ntlm.getUserName(), ntlm.getPassword() != null ? new String(ntlm.getPassword()) : null, ntlm.getWorkstation(), ntlm.getDomain()));
            } else if (credentials instanceof Basic) {
                Basic basic = (Basic)credentials;
                cp.setCredentials(AuthScope.ANY, (org.apache.http.auth.Credentials)new UsernamePasswordCredentials(basic.getUserName(), basic.getPassword() != null ? new String(basic.getPassword()) : null));
            } else {
                throw new IllegalArgumentException("Unsupported credentials");
            }
            builder.setDefaultCredentialsProvider((CredentialsProvider)cp);
        }
        return builder.build();
    }

    private HttpEntityEnclosingRequestBase setupOutput(HttpMessage message, MessageProperties props) throws ProtocolException {
        String acceptEncoding;
        HttpPost msg = new HttpPost(this.m_url.toString());
        msg.setEntity((HttpEntity)message);
        message.setContentType(HttpChannel.getContentTypeProperty(props));
        String acceptType = HttpChannel.getAcceptTypeProperty(props);
        if (acceptType != null) {
            msg.setHeader(ACCEPT_TYPE, acceptType);
        }
        if ((acceptEncoding = HttpChannel.getAcceptEncodingProperty(props)) != null) {
            msg.setHeader(ACCEPT_ENCODING_TYPE, acceptEncoding);
        }
        for (String propertyName : props.getPropertyNames()) {
            msg.setHeader(propertyName, props.getProperty(propertyName));
        }
        return msg;
    }

    private static String getContentTypeProperty(MessageProperties props) {
        MediaType contentType = props.getContentType();
        MediaType.Parameter charset = null;
        MediaType.Parameter action = null;
        if (props.getCharset() != null) {
            charset = new MediaType.Parameter(CHARSET_KEY, props.getCharset().toLowerCase());
        }
        if (props.getOperation() != null) {
            action = new MediaType.Parameter(ACTION_KEY, props.getOperation());
        }
        return contentType.toStringWithParams(new MediaType.Parameter[]{charset, action});
    }

    private static String getAcceptTypeProperty(MessageProperties props) {
        MediaType[] acceptTypes = props.getAcceptTypes();
        if (acceptTypes == null || acceptTypes.length == 0) {
            return null;
        }
        StringBuffer buff = new StringBuffer(64);
        for (int i = 0; i < acceptTypes.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(acceptTypes[i].toString());
        }
        return buff.toString();
    }

    private static String getAcceptEncodingProperty(MessageProperties props) {
        String[] acceptEncoding = props.getAcceptEncoding();
        if (acceptEncoding == null || acceptEncoding.length == 0) {
            return null;
        }
        StringBuilder buff = new StringBuilder(8);
        for (int i = 0; i < acceptEncoding.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(acceptEncoding[i]);
        }
        return buff.toString();
    }

    public InConnection getInbound() throws IOException, WsConfigurationException {
        HttpMessage entity = new HttpMessage();
        HttpGet msg = new HttpGet(this.m_url.toString());
        HttpInConnectionInstance inConnection = this.createInConnection(entity);
        entity.setClient(this.getHttpClient(null, inConnection));
        entity.setRequest((HttpRequestBase)msg);
        return inConnection;
    }

    public OutConnection getOutbound(MessageProperties properties, XmlOptions xmlOptions) throws IOException, WsConfigurationException {
        HttpMessage entity = new HttpMessage();
        entity.setRequest((HttpRequestBase)this.setupOutput(entity, properties));
        HttpOutConnectionInstance outConnection = this.createOutConnection(entity, properties, xmlOptions, true);
        entity.setClient(this.getHttpClient(outConnection, null));
        return outConnection;
    }

    public DuplexConnection getDuplex(MessageProperties properties, XmlOptions xmlOptions) throws IOException, WsConfigurationException {
        HttpMessage entity = new HttpMessage();
        entity.setRequest((HttpRequestBase)this.setupOutput(entity, properties));
        HttpOutConnectionInstance outConnection = this.createOutConnection(entity, properties, xmlOptions, false);
        HttpInConnectionInstance inConnection = this.createInConnection(entity);
        entity.setClient(this.getHttpClient(outConnection, inConnection));
        return new SimpleDuplexConnection(inConnection, outConnection);
    }

    private HttpInConnectionInstance createInConnection(HttpMessage entity) throws WsConfigurationException {
        HttpInConnectionInstance inConn = new HttpInConnectionInstance(entity);
        if (this.m_transportOptions.getInputStreamInterceptor() != null) {
            inConn.setInterceptor(this.m_transportOptions.getInputStreamInterceptor());
        }
        inConn.setup();
        return inConn;
    }

    private HttpOutConnectionInstance createOutConnection(HttpMessage entity, MessageProperties properties, XmlOptions xmlOptions, boolean oneWay) throws WsConfigurationException {
        HttpOutConnectionInstance outConn = new HttpOutConnectionInstance(entity, properties, xmlOptions, oneWay);
        if (this.m_transportOptions.getOutputStreamInterceptor() != null) {
            outConn.setInterceptor(this.m_transportOptions.getOutputStreamInterceptor());
        }
        outConn.setup();
        return outConn;
    }

    public void close() throws IOException {
    }

    private static class HttpMessage
    extends AbstractHttpEntity
    implements Cloneable {
        private CloseableHttpClient client;
        private HttpRequestBase message;
        private ByteArrayOutputStream out = new ByteArrayOutputStream();
        private CloseableHttpResponse response;

        public boolean isRepeatable() {
            return true;
        }

        public long getContentLength() {
            return this.out.size();
        }

        public InputStream getContent() {
            return new ByteArrayInputStream(this.out.toByteArray());
        }

        public void writeTo(OutputStream outstream) throws IOException {
            Args.notNull((Object)outstream, (String)"Output stream");
            outstream.write(this.out.toByteArray());
            outstream.flush();
        }

        public boolean isStreaming() {
            return false;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public OutputStream getOutputStream() {
            return this.out;
        }

        public CloseableHttpResponse getResponse() throws IOException {
            if (this.response != null) {
                return this.response;
            }
            this.response = this.client.execute((HttpUriRequest)this.message);
            return this.response;
        }

        public void setClient(CloseableHttpClient client) {
            this.client = client;
        }

        public CloseableHttpClient getClient() {
            return this.client;
        }

        public void setRequest(HttpRequestBase message) {
            this.message = message;
        }

        public HttpRequestBase getRequest() {
            return this.message;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HttpOutConnectionInstance
    extends OutConnectionBase
    implements HttpOutConnection {
        private final HttpMessage m_entity;
        private final boolean m_oneWay;
        private OutByteBuffer m_buffer;
        private IXMLWriter m_writer;
        private OutputStreamInterceptor m_interceptor;
        private MessageProperties m_msgProps;
        private HttpRequest request;

        public HttpOutConnectionInstance(HttpMessage entity, MessageProperties msgProps, XmlOptions xmlOptions, boolean oneWay) {
            super(xmlOptions);
            this.m_entity = entity;
            this.m_msgProps = msgProps;
            this.m_oneWay = oneWay;
        }

        @Override
        public IXMLWriter getNormalWriter(String[] uris) throws IOException, WsException {
            if (this.m_writer == null) {
                this.m_buffer = (OutByteBuffer)HttpChannel.this.m_outBufferCache.getInstance();
                OutputStream outputStream = this.m_entity.getOutputStream();
                if (this.m_interceptor != null) {
                    outputStream = this.m_interceptor.intercept(outputStream);
                }
                this.m_buffer.setOutput(outputStream);
                this.m_writer = HttpChannel.this.m_codecCache.getCodec(this.m_msgProps.getContentType()).getWriter((IOutByteBuffer)this.m_buffer, null, uris);
                this.initializeWriter(this.m_writer);
            }
            return this.m_writer;
        }

        @Override
        public IXMLWriter getFaultWriter(String[] uris) throws IOException, WsException {
            return this.getNormalWriter(uris);
        }

        public void setInterceptor(OutputStreamInterceptor interceptor) throws WsConfigurationException {
            if (this.m_interceptor != null) {
                throw new WsConfigurationException("Only a single output stream interceptor is supported.");
            }
            this.m_interceptor = interceptor;
        }

        @Override
        public void outputComplete() {
            if (this.m_interceptor != null) {
                this.m_interceptor.outputComplete();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.m_writer != null) {
                this.m_writer.close();
                this.m_writer.reset();
            }
            if (this.m_buffer != null) {
                HttpChannel.this.m_outBufferCache.endUsage(this.m_buffer);
                this.m_buffer = null;
            }
            if (this.m_oneWay) {
                this.m_entity.getClient().close();
            }
        }

        public void setup() {
            if (this.m_interceptor instanceof HttpOutputStreamInterceptor) {
                ((HttpOutputStreamInterceptor)this.m_interceptor).setOutConnection(this);
            }
        }

        public void first(HttpRequest request) {
            this.request = request;
        }

        public void last() {
            if (this.m_interceptor instanceof HttpOutputStreamInterceptor) {
                ((HttpOutputStreamInterceptor)this.m_interceptor).beginOutput();
            }
        }

        @Override
        public void setProperties(Map<String, String[]> properties) {
            HttpRequest r = this.request != null ? this.request : this.m_entity.getRequest();
            for (Map.Entry<String, String[]> entry : properties.entrySet()) {
                String name = entry.getKey();
                r.removeHeaders(name);
                for (String value : entry.getValue()) {
                    r.addHeader(name, value);
                }
            }
        }

        @Override
        public Map<String, String[]> getProperties() {
            HttpRequest r = this.request != null ? this.request : this.m_entity.getRequest();
            HashMap<String, String[]> result = new HashMap<String, String[]>();
            HashMap<String, List<String>> h = new HashMap<String, List<String>>();
            for (Header item : r.getAllHeaders()) {
                String name = item.getName();
                String value = item.getValue();
                List v = (List)h.get(name);
                if (null == v) {
                    h.put(name, Collections.singletonList(value));
                    continue;
                }
                if (v instanceof ArrayList) {
                    v.add(value);
                    continue;
                }
                ArrayList<String> c = new ArrayList<String>();
                c.addAll(v);
                c.add(value);
                h.put(name, c);
            }
            for (Map.Entry entry : h.entrySet()) {
                String name = (String)entry.getKey();
                List values = (List)entry.getValue();
                result.put(name, values.toArray(new String[values.size()]));
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HttpInConnectionInstance
    implements HttpInConnection {
        private static final int MIN_HTTP_ERROR_CODE = 400;
        private static final int ERROR_BUFFER_SIZE = 4000;
        private final HttpMessage m_entity;
        private byte[] m_content;
        private InByteBuffer m_buffer;
        private IXMLReader m_reader;
        private InputStreamInterceptor m_interceptor;
        private HttpResponse response;

        public HttpInConnectionInstance(HttpMessage entity) {
            this.m_entity = entity;
        }

        @Override
        public void init() throws IOException, WsException {
            this.getReader();
            this.m_reader.init();
        }

        @Override
        public String getCharacterEncoding() throws IOException {
            Header header = this.m_entity.getResponse().getEntity().getContentEncoding();
            return header != null ? header.getValue() : null;
        }

        @Override
        public String getContentType() throws IOException {
            Header header = this.m_entity.getResponse().getEntity().getContentType();
            return header != null ? header.getValue() : null;
        }

        @Override
        public String getDestination() {
            return null;
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public String getOperationName() throws IOException {
            int i;
            String opname = null;
            String contentTypeProp = this.getProperty(HttpChannel.CONTENT_TYPE);
            if (contentTypeProp != null && (i = contentTypeProp.indexOf("action=")) != -1) {
                opname = contentTypeProp.substring(i);
            }
            return opname;
        }

        @Override
        public String getOrigin() {
            return null;
        }

        @Override
        public String getProperty(String name) {
            try {
                Header header = (this.response != null ? this.response : this.m_entity.getResponse()).getLastHeader(name);
                return header != null ? header.getValue() : null;
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public Map<String, String[]> getProperties() {
            HashMap<String, String[]> result = new HashMap<String, String[]>();
            try {
                HttpResponse response = this.response != null ? this.response : this.m_entity.getResponse();
                HashMap<String, List<String>> h = new HashMap<String, List<String>>();
                for (Header header : response.getAllHeaders()) {
                    String name = header.getName();
                    String value = header.getValue();
                    List v = (List)h.get(name);
                    if (null == v) {
                        h.put(name, Collections.singletonList(value));
                        continue;
                    }
                    if (v instanceof ArrayList) {
                        v.add(value);
                        continue;
                    }
                    ArrayList<String> c = new ArrayList<String>();
                    c.addAll(v);
                    c.add(value);
                    h.put(name, c);
                }
                for (Map.Entry entry : h.entrySet()) {
                    List values = (List)entry.getValue();
                    result.put((String)entry.getKey(), values.toArray(new String[values.size()]));
                }
                if (!result.containsKey(null)) {
                    result.put(null, new String[]{response.getStatusLine().toString()});
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return result;
        }

        @Override
        public IXMLReader getReader() throws IOException, WsException {
            if (this.m_reader == null) {
                String contentEncoding;
                MediaType mediaType = this.getContentMediaType();
                this.m_buffer = (InByteBuffer)HttpChannel.this.m_inBufferCache.getInstance();
                InputStream inputStream = this.getContentInputStream();
                String characterEncoding = contentEncoding = this.getCharacterEncoding();
                if (contentEncoding != null) {
                    EncodingCodec encodingCodec = HttpChannel.this.m_encodingCodecCache.getCodec(contentEncoding);
                    inputStream = encodingCodec.getInputStream(inputStream);
                    String contentType = this.getProperty(HttpChannel.CONTENT_TYPE);
                    String[] parts = contentType.split(";");
                    characterEncoding = null;
                    for (int i = 1; i < parts.length; ++i) {
                        String name;
                        String part = parts[i];
                        int p = part.indexOf("=");
                        if (-1 == p || !(name = part.substring(0, p)).trim().equals(HttpChannel.CHARSET_KEY)) continue;
                        characterEncoding = part.substring(p + 1).trim();
                    }
                }
                if (this.m_interceptor != null) {
                    inputStream = this.m_interceptor.intercept(inputStream);
                }
                this.m_buffer.setInput(inputStream);
                this.m_reader = HttpChannel.this.m_codecCache.getCodec(mediaType).getReader((IInByteBuffer)this.m_buffer, characterEncoding, this.m_entity.getRequest().getURI().toString(), true);
            }
            return this.m_reader;
        }

        private MediaType getContentMediaType() throws IOException {
            MediaType mediaType = null;
            String ctype = this.getContentType();
            if (ctype != null) {
                MediaType contentType;
                try {
                    contentType = new MediaType(ctype);
                }
                catch (ParseException e) {
                    throw new IOException("Unable to parse content-type '" + ctype + "'");
                }
                if (CodecDirectory.hasCodecFor(contentType)) {
                    mediaType = contentType;
                }
            }
            if (mediaType == null) {
                mediaType = CodecDirectory.TEXT_XML_MEDIA_TYPE;
            }
            return mediaType;
        }

        @Override
        public boolean hasError() throws IOException {
            return this.m_entity.getResponse().getStatusLine().getStatusCode() >= 400;
        }

        @Override
        public String getErrorMessage() throws IOException {
            String line;
            if (!this.hasError()) {
                return null;
            }
            StringBuilder error = new StringBuilder(4000);
            String newLine = System.getProperty("line.separator");
            error.append(this.m_entity.getResponse().getStatusLine().getStatusCode()).append(" ").append(this.m_entity.getResponse().getStatusLine().getReasonPhrase()).append(newLine);
            InputStream errorStream = this.getContentInputStream();
            if (this.m_interceptor != null) {
                errorStream = this.m_interceptor.intercept(errorStream);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(errorStream));
            while ((line = in.readLine()) != null) {
                error.append(line).append(newLine);
            }
            return error.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InputStream getContentInputStream() throws IOException {
            if (!this.hasError()) {
                return this.m_entity.getResponse().getEntity().getContent();
            }
            if (null == this.m_content) {
                long length = this.m_entity.getResponse().getEntity().getContentLength();
                ByteArrayOutputStream out = new ByteArrayOutputStream(length > 0L ? (int)Math.min(length, Integer.MAX_VALUE) : 32);
                try {
                    InputStream in = this.m_entity.getResponse().getEntity().getContent();
                    try {
                        int b;
                        while ((b = in.read()) != -1) {
                            out.write(b);
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                finally {
                    out.close();
                }
                this.m_content = out.toByteArray();
            }
            return new ByteArrayInputStream(this.m_content);
        }

        public void setup() {
            if (this.m_interceptor instanceof HttpInputStreamInterceptor) {
                ((HttpInputStreamInterceptor)this.m_interceptor).setInConnection(this);
            }
        }

        public void first(HttpResponse response) {
            this.response = response;
            this.begin();
        }

        public void begin() {
            if (this.m_interceptor instanceof HttpInputStreamInterceptor) {
                ((HttpInputStreamInterceptor)this.m_interceptor).beginInput();
            }
        }

        public void setInterceptor(InputStreamInterceptor interceptor) throws WsConfigurationException {
            if (this.m_interceptor != null) {
                throw new WsConfigurationException("Only a single input stream interceptor is supported.");
            }
            this.m_interceptor = interceptor;
        }

        @Override
        public void inputComplete() {
            if (this.m_interceptor != null) {
                this.m_interceptor.inputComplete();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.m_buffer != null) {
                HttpChannel.this.m_inBufferCache.endUsage(this.m_buffer);
                this.m_buffer = null;
            }
            this.m_reader = null;
            this.m_entity.getClient().close();
        }
    }
}

