/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.http.client.javase;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.impl.IInByteBuffer;
import org.jibx.runtime.impl.IOutByteBuffer;
import org.jibx.runtime.impl.InByteBuffer;
import org.jibx.runtime.impl.OutByteBuffer;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.WsException;
import org.jibx.ws.codec.CodecCache;
import org.jibx.ws.codec.CodecDirectory;
import org.jibx.ws.codec.EncodingCodec;
import org.jibx.ws.codec.EncodingCodecCache;
import org.jibx.ws.codec.MediaType;
import org.jibx.ws.http.client.HttpInConnection;
import org.jibx.ws.http.client.HttpInputStreamInterceptor;
import org.jibx.ws.http.client.HttpOutConnection;
import org.jibx.ws.http.client.HttpOutputStreamInterceptor;
import org.jibx.ws.http.client.HttpTransportOptions;
import org.jibx.ws.io.XmlOptions;
import org.jibx.ws.transport.Channel;
import org.jibx.ws.transport.DuplexConnection;
import org.jibx.ws.transport.InConnection;
import org.jibx.ws.transport.MessageProperties;
import org.jibx.ws.transport.OutConnection;
import org.jibx.ws.transport.OutConnectionBase;
import org.jibx.ws.transport.SimpleDuplexConnection;
import org.jibx.ws.transport.StreamBufferInPool;
import org.jibx.ws.transport.StreamBufferOutPool;
import org.jibx.ws.transport.interceptor.InputStreamInterceptor;
import org.jibx.ws.transport.interceptor.OutputStreamInterceptor;

public final class HttpChannel
implements Channel {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CHARSET_KEY = "charset";
    private static final String ACTION_KEY = "action";
    private static final String ACCEPT_TYPE = "Accept";
    private static final String ACCEPT_ENCODING_TYPE = "Accept-Encoding";
    private static final int BUFFER_SIZE = 8192;
    private final URL m_url;
    private final CodecCache m_codecCache;
    private final EncodingCodecCache m_encodingCodecCache;
    private final StreamBufferInPool m_inBufferCache;
    private final StreamBufferOutPool m_outBufferCache;
    private HttpTransportOptions m_transportOptions;

    public HttpChannel(URL url, HttpTransportOptions transportOptions) {
        this.m_url = url;
        this.m_transportOptions = transportOptions;
        this.m_codecCache = new CodecCache();
        this.m_encodingCodecCache = new EncodingCodecCache();
        this.m_inBufferCache = new StreamBufferInPool(8192);
        this.m_outBufferCache = new StreamBufferOutPool(8192);
    }

    private static void setupOutput(HttpURLConnection connection, MessageProperties props) throws ProtocolException {
        String acceptEncoding;
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty(CONTENT_TYPE, HttpChannel.getContentTypeProperty(props));
        String acceptType = HttpChannel.getAcceptTypeProperty(props);
        if (acceptType != null) {
            connection.setRequestProperty(ACCEPT_TYPE, acceptType);
        }
        if ((acceptEncoding = HttpChannel.getAcceptEncodingProperty(props)) != null) {
            connection.setRequestProperty(ACCEPT_ENCODING_TYPE, acceptEncoding);
        }
        for (String propertyName : props.getPropertyNames()) {
            connection.setRequestProperty(propertyName, props.getProperty(propertyName));
        }
    }

    private static String getContentTypeProperty(MessageProperties props) {
        MediaType contentType = props.getContentType();
        MediaType.Parameter charset = null;
        MediaType.Parameter action = null;
        if (props.getCharset() != null) {
            charset = new MediaType.Parameter(CHARSET_KEY, props.getCharset().toLowerCase());
        }
        if (props.getOperation() != null) {
            action = new MediaType.Parameter(ACTION_KEY, props.getOperation());
        }
        return contentType.toStringWithParams(new MediaType.Parameter[]{charset, action});
    }

    private static String getAcceptTypeProperty(MessageProperties props) {
        MediaType[] acceptTypes = props.getAcceptTypes();
        if (acceptTypes == null || acceptTypes.length == 0) {
            return null;
        }
        StringBuffer buff = new StringBuffer(64);
        for (int i = 0; i < acceptTypes.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(acceptTypes[i].toString());
        }
        return buff.toString();
    }

    private static String getAcceptEncodingProperty(MessageProperties props) {
        String[] acceptEncoding = props.getAcceptEncoding();
        if (acceptEncoding == null || acceptEncoding.length == 0) {
            return null;
        }
        StringBuilder buff = new StringBuilder(8);
        for (int i = 0; i < acceptEncoding.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(acceptEncoding[i]);
        }
        return buff.toString();
    }

    public InConnection getInbound() throws IOException, WsConfigurationException {
        HttpURLConnection connection = (HttpURLConnection)this.m_url.openConnection();
        this.setupConnection(connection);
        connection.connect();
        return this.createInConnection(connection);
    }

    public OutConnection getOutbound(MessageProperties properties, XmlOptions xmlOptions) throws IOException, WsConfigurationException {
        HttpURLConnection connection = (HttpURLConnection)this.m_url.openConnection();
        this.setupConnection(connection);
        connection.setDoInput(false);
        HttpChannel.setupOutput(connection, properties);
        HttpOutConnectionInstance outConnection = this.createOutConnection(connection, properties, xmlOptions);
        outConnection.begin();
        connection.connect();
        return outConnection;
    }

    public DuplexConnection getDuplex(MessageProperties properties, XmlOptions xmlOptions) throws IOException, WsConfigurationException {
        HttpURLConnection connection = (HttpURLConnection)this.m_url.openConnection();
        this.setupConnection(connection);
        connection.setDoInput(true);
        HttpChannel.setupOutput(connection, properties);
        HttpOutConnectionInstance outConnection = this.createOutConnection(connection, properties, xmlOptions);
        outConnection.begin();
        connection.connect();
        return new SimpleDuplexConnection(this.createInConnection(connection), outConnection);
    }

    private void setupConnection(HttpURLConnection connection) {
        if (this.m_transportOptions.getConnectTimeout() != null) {
            connection.setConnectTimeout(this.m_transportOptions.getConnectTimeout());
        }
        if (this.m_transportOptions.getReadTimeout() != null) {
            connection.setReadTimeout(this.m_transportOptions.getReadTimeout());
        }
        if (this.m_transportOptions.getSslContext() != null) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(this.m_transportOptions.getSslContext().getSocketFactory());
        }
        if (this.m_transportOptions.getSSLHostnameVerifier() != null) {
            ((HttpsURLConnection)connection).setHostnameVerifier(this.m_transportOptions.getSSLHostnameVerifier());
        }
    }

    private HttpInConnectionInstance createInConnection(HttpURLConnection connection) throws WsConfigurationException {
        HttpInConnectionInstance inConn = new HttpInConnectionInstance(connection);
        if (this.m_transportOptions.getInputStreamInterceptor() != null) {
            inConn.setInterceptor(this.m_transportOptions.getInputStreamInterceptor());
        }
        inConn.setup();
        return inConn;
    }

    private HttpOutConnectionInstance createOutConnection(HttpURLConnection connection, MessageProperties properties, XmlOptions xmlOptions) throws WsConfigurationException {
        HttpOutConnectionInstance outConn = new HttpOutConnectionInstance(connection, properties, xmlOptions);
        if (this.m_transportOptions.getOutputStreamInterceptor() != null) {
            outConn.setInterceptor(this.m_transportOptions.getOutputStreamInterceptor());
        }
        outConn.setup();
        return outConn;
    }

    public void close() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HttpOutConnectionInstance
    extends OutConnectionBase
    implements HttpOutConnection {
        private final HttpURLConnection m_connection;
        private OutByteBuffer m_buffer;
        private IXMLWriter m_writer;
        private OutputStreamInterceptor m_interceptor;
        private MessageProperties m_msgProps;

        public HttpOutConnectionInstance(HttpURLConnection connection, MessageProperties msgProps, XmlOptions xmlOptions) {
            super(xmlOptions);
            this.m_connection = connection;
            this.m_msgProps = msgProps;
        }

        @Override
        public IXMLWriter getNormalWriter(String[] uris) throws IOException, WsException {
            if (this.m_writer == null) {
                this.m_buffer = (OutByteBuffer)HttpChannel.this.m_outBufferCache.getInstance();
                OutputStream outputStream = this.m_connection.getOutputStream();
                if (this.m_interceptor != null) {
                    outputStream = this.m_interceptor.intercept(outputStream);
                }
                this.m_buffer.setOutput(outputStream);
                this.m_writer = HttpChannel.this.m_codecCache.getCodec(this.m_msgProps.getContentType()).getWriter((IOutByteBuffer)this.m_buffer, null, uris);
                this.initializeWriter(this.m_writer);
            }
            return this.m_writer;
        }

        @Override
        public IXMLWriter getFaultWriter(String[] uris) throws IOException, WsException {
            return this.getNormalWriter(uris);
        }

        public void setInterceptor(OutputStreamInterceptor interceptor) throws WsConfigurationException {
            if (this.m_interceptor != null) {
                throw new WsConfigurationException("Only a single output stream interceptor is supported.");
            }
            this.m_interceptor = interceptor;
        }

        @Override
        public void outputComplete() {
            if (this.m_interceptor != null) {
                this.m_interceptor.outputComplete();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.m_writer != null) {
                this.m_writer.close();
                this.m_writer.reset();
            }
            if (this.m_buffer != null) {
                HttpChannel.this.m_outBufferCache.endUsage(this.m_buffer);
                this.m_buffer = null;
            }
        }

        public void setup() {
            if (this.m_interceptor instanceof HttpOutputStreamInterceptor) {
                ((HttpOutputStreamInterceptor)this.m_interceptor).setOutConnection(this);
            }
        }

        public void begin() {
            if (this.m_interceptor instanceof HttpOutputStreamInterceptor) {
                ((HttpOutputStreamInterceptor)this.m_interceptor).beginOutput();
            }
        }

        @Override
        public void setProperties(Map<String, String[]> properties) {
            for (Map.Entry<String, String[]> entry : properties.entrySet()) {
                String name = entry.getKey();
                boolean first = true;
                for (String value : entry.getValue()) {
                    if (first) {
                        this.m_connection.setRequestProperty(name, value);
                        first = false;
                        continue;
                    }
                    this.m_connection.addRequestProperty(name, value);
                }
            }
        }

        @Override
        public Map<String, String[]> getProperties() {
            HashMap<String, String[]> result = new HashMap<String, String[]>();
            for (Map.Entry<String, List<String>> item : this.m_connection.getRequestProperties().entrySet()) {
                List<String> values = item.getValue();
                if (values == null || values.size() <= 0) continue;
                result.put(item.getKey(), values.toArray(new String[values.size()]));
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HttpInConnectionInstance
    implements HttpInConnection {
        private static final int MIN_HTTP_ERROR_CODE = 400;
        private static final int ERROR_BUFFER_SIZE = 4000;
        private final HttpURLConnection m_connection;
        private InByteBuffer m_buffer;
        private IXMLReader m_reader;
        private InputStreamInterceptor m_interceptor;

        public HttpInConnectionInstance(HttpURLConnection connection) {
            this.m_connection = connection;
        }

        @Override
        public void init() throws IOException, WsException {
            this.getReader();
            this.m_reader.init();
            this.begin();
        }

        @Override
        public String getCharacterEncoding() {
            return this.m_connection.getContentEncoding();
        }

        @Override
        public String getContentType() {
            return this.m_connection.getContentType();
        }

        @Override
        public String getDestination() {
            return null;
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public String getOperationName() {
            int i;
            String opname = null;
            String contentTypeProp = this.getProperty(HttpChannel.CONTENT_TYPE);
            if (contentTypeProp != null && (i = contentTypeProp.indexOf("action=")) != -1) {
                opname = contentTypeProp.substring(i);
            }
            return opname;
        }

        @Override
        public String getOrigin() {
            return null;
        }

        @Override
        public String getProperty(String name) {
            return this.m_connection.getHeaderField(name);
        }

        @Override
        public Map<String, String[]> getProperties() {
            HashMap<String, String[]> result = new HashMap<String, String[]>();
            for (Map.Entry<String, List<String>> item : this.m_connection.getHeaderFields().entrySet()) {
                List<String> values = item.getValue();
                if (values == null || values.size() <= 0) continue;
                result.put(item.getKey(), values.toArray(new String[values.size()]));
            }
            return result;
        }

        @Override
        public IXMLReader getReader() throws IOException, WsException {
            if (this.m_reader == null) {
                String contentEncoding;
                MediaType mediaType = this.getContentMediaType();
                this.m_buffer = (InByteBuffer)HttpChannel.this.m_inBufferCache.getInstance();
                InputStream inputStream = this.hasError() ? this.m_connection.getErrorStream() : this.m_connection.getInputStream();
                String characterEncoding = contentEncoding = this.getCharacterEncoding();
                if (contentEncoding != null) {
                    EncodingCodec encodingCodec = HttpChannel.this.m_encodingCodecCache.getCodec(contentEncoding);
                    inputStream = encodingCodec.getInputStream(inputStream);
                    String contentType = this.getProperty(HttpChannel.CONTENT_TYPE);
                    String[] parts = contentType.split(";");
                    characterEncoding = null;
                    for (int i = 1; i < parts.length; ++i) {
                        String name;
                        String part = parts[i];
                        int p = part.indexOf("=");
                        if (-1 == p || !(name = part.substring(0, p)).trim().equals(HttpChannel.CHARSET_KEY)) continue;
                        characterEncoding = part.substring(p + 1).trim();
                    }
                }
                if (this.m_interceptor != null) {
                    inputStream = this.m_interceptor.intercept(inputStream);
                }
                this.m_buffer.setInput(inputStream);
                this.m_reader = HttpChannel.this.m_codecCache.getCodec(mediaType).getReader((IInByteBuffer)this.m_buffer, characterEncoding, this.m_connection.getURL().toExternalForm(), true);
            }
            return this.m_reader;
        }

        private MediaType getContentMediaType() throws IOException {
            MediaType mediaType = null;
            String ctype = this.getContentType();
            if (ctype != null) {
                MediaType contentType;
                try {
                    contentType = new MediaType(ctype);
                }
                catch (ParseException e) {
                    throw new IOException("Unable to parse content-type '" + ctype + "'");
                }
                if (CodecDirectory.hasCodecFor(contentType)) {
                    mediaType = contentType;
                }
            }
            if (mediaType == null) {
                mediaType = CodecDirectory.TEXT_XML_MEDIA_TYPE;
            }
            return mediaType;
        }

        @Override
        public boolean hasError() throws IOException {
            return this.m_connection.getResponseCode() >= 400;
        }

        @Override
        public String getErrorMessage() throws IOException {
            String line;
            if (!this.hasError()) {
                return null;
            }
            StringBuffer error = new StringBuffer(4000);
            String newLine = System.getProperty("line.separator");
            error.append(this.m_connection.getResponseCode()).append(" ").append(this.m_connection.getResponseMessage()).append(newLine);
            InputStream errorStream = this.m_connection.getErrorStream();
            if (this.m_interceptor != null) {
                errorStream = this.m_interceptor.intercept(errorStream);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(errorStream));
            while ((line = in.readLine()) != null) {
                error.append(line).append(newLine);
            }
            return error.toString();
        }

        public void setup() {
            if (this.m_interceptor instanceof HttpInputStreamInterceptor) {
                ((HttpInputStreamInterceptor)this.m_interceptor).setInConnection(this);
            }
        }

        public void begin() {
            if (this.m_interceptor instanceof HttpInputStreamInterceptor) {
                ((HttpInputStreamInterceptor)this.m_interceptor).beginInput();
            }
        }

        public void setInterceptor(InputStreamInterceptor interceptor) throws WsConfigurationException {
            if (this.m_interceptor != null) {
                throw new WsConfigurationException("Only a single input stream interceptor is supported.");
            }
            this.m_interceptor = interceptor;
        }

        @Override
        public void inputComplete() {
            if (this.m_interceptor != null) {
                this.m_interceptor.inputComplete();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.m_buffer != null) {
                HttpChannel.this.m_inBufferCache.endUsage(this.m_buffer);
                this.m_buffer = null;
            }
            this.m_reader = null;
        }
    }
}

