/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.io;

import org.jibx.ws.io.XmlEncoding;

public final class XmlOptions {
    private XmlEncoding m_encoding;
    private Boolean m_standaloneDecl;
    private boolean m_includeEncodingDecl;
    private char m_indentChar;
    private int m_indentCount;
    private String m_newLine;

    public XmlOptions() {
        this.setEncoding(XmlEncoding.UTF_8);
        this.setIncludeEncodingDecl(false);
        this.setStandaloneDecl(null);
        this.setIndentChar(' ');
        this.setIndentCount(-1);
    }

    public XmlOptions(XmlOptions options) {
        this.setEncoding(options.getEncoding());
        this.setIncludeEncodingDecl(options.isIncludeEncodingDecl());
        this.setStandaloneDecl(options.getStandaloneDecl());
        this.setIndentCount(options.getIndentCount());
        this.setIndentChar(options.getIndentChar());
        this.setNewLine(options.getNewLine());
    }

    public XmlOptions(XmlEncoding encoding) {
        this();
        this.setEncoding(encoding);
    }

    public XmlOptions(XmlEncoding encoding, boolean includeEncodingDecl, Boolean standaloneDecl) {
        this(encoding);
        this.setIncludeEncodingDecl(includeEncodingDecl);
        this.setStandaloneDecl(standaloneDecl);
    }

    public XmlOptions(char indentChar, int indentCount, String newLine) {
        this();
        this.setIndentChar(indentChar);
        this.setIndentCount(indentCount);
        this.setNewLine(newLine);
    }

    public XmlOptions(XmlEncoding encoding, char indentChar, int indentCount, String newLine) {
        this(encoding);
        this.setIndentChar(indentChar);
        this.setIndentCount(indentCount);
        this.setNewLine(newLine);
    }

    public XmlOptions(XmlEncoding encoding, boolean includeEncodingDecl, Boolean standaloneDecl, char indentChar, int indentCount, String newLine) {
        this(encoding);
        this.setIncludeEncodingDecl(includeEncodingDecl);
        this.setStandaloneDecl(standaloneDecl);
        this.setIndentChar(indentChar);
        this.setIndentCount(indentCount);
        this.setNewLine(newLine);
    }

    public XmlEncoding getEncoding() {
        return this.m_encoding;
    }

    public void setEncoding(XmlEncoding encoding) {
        this.m_encoding = encoding;
    }

    public int getIndentCount() {
        return this.m_indentCount;
    }

    public void setIndentCount(int indentCount) {
        this.m_indentCount = indentCount;
    }

    public char getIndentChar() {
        return this.m_indentChar;
    }

    public void setIndentChar(char indentChar) {
        this.m_indentChar = indentChar;
    }

    public String getNewLine() {
        return this.m_newLine;
    }

    public void setNewLine(String newLine) {
        this.m_newLine = newLine;
    }

    public Boolean getStandaloneDecl() {
        return this.m_standaloneDecl;
    }

    public void setStandaloneDecl(Boolean standaloneDecl) {
        this.m_standaloneDecl = standaloneDecl;
    }

    public boolean isIncludeEncodingDecl() {
        return this.m_includeEncodingDecl;
    }

    public void setIncludeEncodingDecl(boolean includeEncodingDecl) {
        this.m_includeEncodingDecl = includeEncodingDecl;
    }

    public String getEncodingDeclString() {
        if (this.m_includeEncodingDecl) {
            return this.m_encoding.toString();
        }
        return null;
    }

    public String getStandaloneDeclString() {
        if (this.m_standaloneDecl == null) {
            return null;
        }
        if (this.m_standaloneDecl.equals(Boolean.TRUE)) {
            return "yes";
        }
        return "no";
    }
}

