/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.io.handler;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jibx.runtime.IXMLWriter;
import org.jibx.ws.WsException;
import org.jibx.ws.context.OutContext;
import org.jibx.ws.io.handler.OutHandler;

public final class ExceptionWriter
implements OutHandler {
    private static final String ELEMENT_NAME = "Exception";
    private static final String MESSAGE_SEPARATOR = ": ";
    private final Throwable m_throwable;
    private final boolean m_includeStackTrace;

    public ExceptionWriter(Throwable t, boolean includeStackTrace) {
        this.m_throwable = t;
        this.m_includeStackTrace = includeStackTrace;
    }

    public void invoke(OutContext context, IXMLWriter xmlWriter) throws IOException, WsException {
        xmlWriter.startTagClosed(0, ELEMENT_NAME);
        if (this.m_includeStackTrace) {
            StringWriter sw = new StringWriter();
            this.m_throwable.printStackTrace(new PrintWriter(sw));
            xmlWriter.writeTextContent(sw.toString());
        } else {
            xmlWriter.writeTextContent(this.m_throwable.getClass().getName() + MESSAGE_SEPARATOR + this.m_throwable.getLocalizedMessage());
        }
        xmlWriter.endTag(0, ELEMENT_NAME);
    }
}

