/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.pox;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.ws.WsException;
import org.jibx.ws.context.ExchangeContext;
import org.jibx.ws.context.InContext;
import org.jibx.ws.context.MessageContext;
import org.jibx.ws.context.OutContext;
import org.jibx.ws.process.Processor;
import org.jibx.ws.transport.InConnection;
import org.jibx.ws.transport.OutConnection;
import org.jibx.ws.transport.WsTransportException;

public final class PoxProcessor
implements Processor {
    private static final Log logger = LogFactory.getLog(PoxProcessor.class);
    private static final String[] DEFAULT_NS = new String[]{"", "http://www.w3.org/XML/1998/namespace"};
    private ExchangeContext m_exchangeCtx;

    public PoxProcessor() {
    }

    public PoxProcessor(ExchangeContext exchangeContext) {
        this.m_exchangeCtx = exchangeContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(OutConnection oconn, InConnection iconn) throws IOException, WsException {
        boolean ic;
        block8: {
            MessageContext msgCtx = this.m_exchangeCtx.getCurrentMessageContext();
            boolean oc = false;
            ic = false;
            try {
                while (msgCtx != null) {
                    if (msgCtx.isOutbound()) {
                        this.sendMessage(oconn);
                        oconn.close();
                        oc = true;
                    } else {
                        this.receiveMessage(iconn);
                        iconn.close();
                        ic = true;
                    }
                    this.m_exchangeCtx.switchMessageContext();
                    msgCtx = this.m_exchangeCtx.getCurrentMessageContext();
                }
                Object var7_6 = null;
                if (oc) break block8;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (!oc) {
                    oconn.close();
                }
                if (!ic) {
                    iconn.close();
                }
                throw throwable;
            }
            oconn.close();
        }
        if (!ic) {
            iconn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(OutConnection conn) throws IOException, WsException {
        if (this.m_exchangeCtx.getCurrentMessageContext() == null) {
            throw new IllegalStateException("No message context available for sending message");
        }
        if (!this.m_exchangeCtx.getCurrentMessageContext().isOutbound()) {
            throw new IllegalStateException("Cannot send message when current message context is inbound");
        }
        OutContext context = (OutContext)this.m_exchangeCtx.getCurrentMessageContext();
        try {
            logger.debug((Object)"Starting send message");
            context.invokeBodyWriter(conn.getNormalWriter(DEFAULT_NS));
            logger.debug((Object)"Message sent");
            Object var4_3 = null;
            conn.outputComplete();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            conn.outputComplete();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage(InConnection conn) throws IOException, WsException {
        if (this.m_exchangeCtx.getCurrentMessageContext() == null) {
            throw new IllegalStateException("No message context available for receiving message");
        }
        if (this.m_exchangeCtx.getCurrentMessageContext().isOutbound()) {
            throw new IllegalStateException("Cannot receive message when current message context is outbound");
        }
        InContext context = (InContext)this.m_exchangeCtx.getCurrentMessageContext();
        try {
            conn.init();
            if (conn.hasError()) {
                throw new WsTransportException(conn.getErrorMessage());
            }
            logger.debug((Object)"Starting receive message");
            context.invokeBodyReader(conn.getReader());
            if (context.getBody() == null) {
                throw new WsException("No handlers could be found for unmarshalling the body payload");
            }
            logger.debug((Object)"Message received");
            Object var4_3 = null;
            conn.inputComplete();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            conn.inputComplete();
            throw throwable;
        }
    }

    public void setExchangeContext(ExchangeContext exchangeCtx) {
        this.m_exchangeCtx = exchangeCtx;
    }

    public void reset() {
        this.m_exchangeCtx.reset();
    }

    public MessageContext getCurrentMessageContext() {
        return this.m_exchangeCtx.getCurrentMessageContext();
    }

    public MessageContext getNextMessageContext() {
        return this.m_exchangeCtx.getNextMessageContext();
    }

    public void switchMessageContext() {
        this.m_exchangeCtx.switchMessageContext();
    }
}

