/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.pox;

import org.jibx.runtime.IBindingFactory;
import org.jibx.ws.UnhandledWsException;
import org.jibx.ws.WsBindingException;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.WsException;
import org.jibx.ws.client.Client;
import org.jibx.ws.codec.CodecDirectory;
import org.jibx.ws.codec.MediaType;
import org.jibx.ws.context.ExchangeContext;
import org.jibx.ws.io.MessageOptions;
import org.jibx.ws.pox.PoxProcessor;
import org.jibx.ws.pox.client.PoxClient;
import org.jibx.ws.pox.server.PoxService;
import org.jibx.ws.process.Processor;
import org.jibx.ws.protocol.Protocol;
import org.jibx.ws.server.MediaTypeMapper;
import org.jibx.ws.server.Service;
import org.jibx.ws.server.ServiceDefinition;
import org.jibx.ws.server.ServiceExceptionHandler;
import org.jibx.ws.server.ServiceExceptionHandlerFactory;
import org.jibx.ws.server.ServiceFactory;
import org.jibx.ws.transport.InConnection;
import org.jibx.ws.transport.MessageProperties;
import org.jibx.ws.transport.OutServerConnection;

public final class PoxProtocol
implements Protocol {
    public static final PoxProtocol INSTANCE = new PoxProtocol();
    private static ServiceFactory s_serviceFactory = new ServiceFactory(){

        public Service createInstance(ServiceDefinition sdef) throws WsException {
            return new PoxService(sdef, new PoxProcessor(), s_mediaTypeMapper, PoxProtocol.getDefaultExceptionHandlerFactory(sdef.getIncludeStackTraceOnFault()));
        }
    };
    private static final MediaTypeMapper s_mediaTypeMapper;
    private static ServiceExceptionHandlerFactory s_defaultExceptionHandlerFactory;

    public Client createClient(String location, IBindingFactory factory, MessageOptions options) throws WsBindingException, WsConfigurationException {
        return new PoxClient(location, factory, options);
    }

    public Processor createProcessor(ExchangeContext exchangeContext) {
        return new PoxProcessor(exchangeContext);
    }

    public Processor createProcessor() {
        return new PoxProcessor();
    }

    public String getName() {
        return "POX";
    }

    public ServiceFactory getServiceFactory() {
        return s_serviceFactory;
    }

    public MediaTypeMapper getMediaTypeMapper() {
        return s_mediaTypeMapper;
    }

    public MessageProperties buildMessageProperties(String opname, MessageOptions msgOptions) throws WsConfigurationException {
        String charset = msgOptions.getEncoding().toString();
        String outtype = msgOptions.getOutMediaTypeCode();
        String[] intypes = msgOptions.getInMediaTypeCodes();
        MessageProperties props = new MessageProperties();
        props.setContentType(this.getMediaTypeMapper().getMediaTypeFor(outtype));
        MediaType[] acceptTypes = new MediaType[intypes.length];
        for (int i = 0; i < intypes.length; ++i) {
            acceptTypes[i] = this.getMediaTypeMapper().getMediaTypeFor(intypes[i]);
        }
        props.setAcceptTypes(acceptTypes);
        if (charset != null) {
            props.setCharset(charset);
        }
        return props;
    }

    public String getOperationName(InConnection conn) {
        throw new UnsupportedOperationException();
    }

    public static ServiceExceptionHandlerFactory getDefaultExceptionHandlerFactory(boolean includeStackTrace) {
        return s_defaultExceptionHandlerFactory;
    }

    static {
        s_defaultExceptionHandlerFactory = new ServiceExceptionHandlerFactory(){

            public ServiceExceptionHandler createServiceExceptionHandler() {
                return new ServiceExceptionHandler(){

                    public void handleException(Throwable e, Processor processor, OutServerConnection outConn) {
                        throw UnhandledWsException.wrap(e);
                    }
                };
            }
        };
        s_mediaTypeMapper = new MediaTypeMapper(){

            public MediaType getMediaTypeFor(String code) throws WsConfigurationException {
                if (code == null || "xml".equals(code)) {
                    return CodecDirectory.TEXT_XML_MEDIA_TYPE;
                }
                MediaType type = new MediaType("application", code);
                if (!CodecDirectory.hasCodecFor(type)) {
                    throw new WsConfigurationException("No codec available for media type '" + type + "' based on media type code '" + code + "' with protocol POX");
                }
                return type;
            }
        };
    }
}

