/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.jibx.ws.WsBindingException;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.io.XmlOptions;
import org.jibx.ws.server.BindingLocator;
import org.jibx.ws.server.HandlerDefinition;
import org.jibx.ws.server.JiBX_service_mappingMungeAdapter;
import org.jibx.ws.server.ServiceExceptionHandler;
import org.jibx.ws.server.TransportOptionsDefinition;
import org.jibx.ws.transport.OutputCompletionListener;
import org.jibx.ws.util.Utility;

public final class ServiceDefinition
implements IUnmarshallable {
    private String m_protocolName;
    private String m_serviceName;
    private Object m_serviceObject;
    private String m_serviceClassName;
    private Class m_serviceClass;
    private ServiceExceptionHandler m_serviceExceptionHandlerObject;
    private Class m_serviceExceptionHandlerClass;
    private IBindingFactory m_inBodyBindingFactory;
    private IBindingFactory m_outBodyBindingFactory;
    private List m_hdefs;
    private List m_opdefs;
    private boolean m_includeStackTraceOnFault;
    private OutputCompletionListener m_outputCompletionListenerObject;
    private Class m_outputCompletionListenerClass;
    private XmlOptions m_xmlOptions;
    private List m_transportOptDefs;
    private String m_wsdlFilepath;
    private boolean m_wsdlLocationTransform;
    public static final String JiBX_bindingList = "|org.jibx.ws.server.JiBX_service_mappingFactory|";

    protected void postset(IUnmarshallingContext ctx) throws JiBXException {
        try {
            this.init();
        }
        catch (WsConfigurationException e) {
            throw new JiBXException("Error initializing ServiceDefinition", (Throwable)e);
        }
    }

    public void init() throws WsConfigurationException {
        for (int i = 0; i < this.getHandlerDefinitions().size(); ++i) {
            HandlerDefinition hdef = (HandlerDefinition)this.getHandlerDefinitions().get(i);
            hdef.init();
        }
        this.checkForDuplicateTransportOptionDefinitions();
        for (TransportOptionsDefinition todef : this.getTransportOptionsDefinitions()) {
            todef.init();
        }
        if (this.m_serviceName == null) {
            this.m_serviceName = "Service";
        }
        if (this.getProtocolName() == null) {
            this.setProtocolName("SOAP1.1");
        }
    }

    private void checkForDuplicateTransportOptionDefinitions() {
        if (this.m_transportOptDefs != null) {
            HashSet<String> definedOptions = new HashSet<String>();
            for (TransportOptionsDefinition def : this.m_transportOptDefs) {
                String type = def.getClass().getName();
                if (definedOptions.contains(type)) {
                    throw new IllegalArgumentException("Duplicate transport options definition of type " + type);
                }
                definedOptions.add(type);
            }
        }
    }

    public void setProtocolName(String name) {
        this.m_protocolName = name;
    }

    public String getProtocolName() {
        return this.m_protocolName;
    }

    public void setIndentCount(int indentCount) {
        this.getXmlOptions().setIndentCount(indentCount);
    }

    public void setXmlOptions(XmlOptions options) {
        this.m_xmlOptions = options;
    }

    public XmlOptions getXmlOptions() {
        if (this.m_xmlOptions == null) {
            this.m_xmlOptions = new XmlOptions();
        }
        return this.m_xmlOptions;
    }

    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public Object getServiceObject() {
        return this.m_serviceObject;
    }

    public void setServiceObject(Object serviceObject) {
        this.m_serviceObject = serviceObject;
    }

    public void setServiceClassName(String serviceClassName) {
        this.m_serviceClassName = serviceClassName;
    }

    public Class getServiceClass() throws WsConfigurationException {
        if (this.m_serviceClass == null) {
            if (this.m_serviceObject != null) {
                this.m_serviceClass = this.m_serviceObject.getClass();
            } else {
                this.m_serviceClass = Utility.loadClass(this.m_serviceClassName);
                if (this.m_serviceClass == null) {
                    throw new WsConfigurationException("Service class " + this.m_serviceClassName + " not found in classpath");
                }
            }
        }
        return this.m_serviceClass;
    }

    public ServiceExceptionHandler getServiceExceptionHandlerObject() {
        return this.m_serviceExceptionHandlerObject;
    }

    public void setServiceExceptionHandlerObject(ServiceExceptionHandler serviceExceptionHandler) {
        this.m_serviceExceptionHandlerObject = serviceExceptionHandler;
    }

    public void setServiceExceptionHandlerClassName(String serviceExceptionHandlerClassName) throws WsConfigurationException {
        if (serviceExceptionHandlerClassName != null) {
            this.m_serviceExceptionHandlerClass = Utility.loadClass(serviceExceptionHandlerClassName);
            if (this.m_serviceExceptionHandlerClass == null) {
                throw new WsConfigurationException("Fault handler class " + serviceExceptionHandlerClassName + " not found in classpath");
            }
        }
    }

    public Class getServiceExceptionHandlerClass() {
        return this.m_serviceExceptionHandlerClass;
    }

    private void setBindingLocator(BindingLocator locator) throws WsBindingException, WsConfigurationException {
        if (locator != null) {
            this.setBindingFactory(locator.getBindingFactory());
        }
    }

    private void setInBodyBindingLocator(BindingLocator locator) throws WsBindingException, WsConfigurationException {
        if (locator != null) {
            this.setInBodyBindingFactory(locator.getBindingFactory());
        }
    }

    private void setOutBodyBindingLocator(BindingLocator locator) throws WsBindingException, WsConfigurationException {
        if (locator != null) {
            this.setOutBodyBindingFactory(locator.getBindingFactory());
        }
    }

    public void setBindingFactory(IBindingFactory factory) {
        this.setInBodyBindingFactory(factory);
        this.setOutBodyBindingFactory(factory);
    }

    public void setInBodyBindingFactory(IBindingFactory factory) {
        this.m_inBodyBindingFactory = factory;
    }

    public IBindingFactory getInBodyBindingFactory() {
        return this.m_inBodyBindingFactory;
    }

    public void setOutBodyBindingFactory(IBindingFactory factory) {
        this.m_outBodyBindingFactory = factory;
    }

    public IBindingFactory getOutBodyBindingFactory() {
        return this.m_outBodyBindingFactory;
    }

    public void setHandlerDefinitions(List hdefs) {
        this.m_hdefs = hdefs;
    }

    public List getHandlerDefinitions() {
        if (this.m_hdefs == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_hdefs;
    }

    public void setOperationDefinitions(List opdefs) {
        this.m_opdefs = opdefs;
    }

    public List getOperationDefinitions() {
        return this.m_opdefs;
    }

    public void setIncludeStackTraceOnFault(boolean includeStackTraceOnFault) {
        this.m_includeStackTraceOnFault = includeStackTraceOnFault;
    }

    public boolean getIncludeStackTraceOnFault() {
        return this.m_includeStackTraceOnFault;
    }

    public void setOutputCompletionListenerClassName(String outputCompletionListenerClassName) throws WsConfigurationException {
        if (outputCompletionListenerClassName != null) {
            this.m_outputCompletionListenerClass = Utility.loadClass(outputCompletionListenerClassName);
            if (this.m_outputCompletionListenerClass == null) {
                throw new WsConfigurationException("Output Listener class " + outputCompletionListenerClassName + " not found in classpath");
            }
        }
    }

    public void setOutputCompletionListener(OutputCompletionListener listener) {
        this.m_outputCompletionListenerObject = listener;
    }

    public OutputCompletionListener getOutputCompletionListenerObject() {
        return this.m_outputCompletionListenerObject;
    }

    public Class getOutputCompletionListenerClass() {
        return this.m_outputCompletionListenerClass;
    }

    public void setTransportOptionsDefinitions(List definitions) {
        this.m_transportOptDefs = definitions;
    }

    protected Collection getTransportOptionsDefinitions() {
        if (this.m_transportOptDefs == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_transportOptDefs;
    }

    public void setWsdlFilepath(String wsdlFilepath) {
        this.m_wsdlFilepath = wsdlFilepath;
    }

    protected String getWsdlFilepath() {
        return this.m_wsdlFilepath;
    }

    public void setWsdlLocationTransform(boolean transform) {
        this.m_wsdlLocationTransform = transform;
    }

    protected boolean getWsdlLocationTransform() {
        return this.m_wsdlLocationTransform;
    }

    public static /* synthetic */ ServiceDefinition JiBX_service_mapping_newinstance_1_0(ServiceDefinition arg1, UnmarshallingContext arg2) throws JiBXException {
        if (arg1 == null) {
            arg1 = new ServiceDefinition();
        }
        return arg1;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ ServiceDefinition JiBX_service_mapping_unmarshalAttr_1_0(ServiceDefinition arg1, UnmarshallingContext arg2) throws JiBXException {
        ServiceDefinition serviceDefinition;
        void var1_1;
        arg2.pushTrackedObject((Object)arg1);
        ServiceDefinition serviceDefinition2 = arg1;
        String var2 = arg2.attributeText(null, "protocol", null);
        arg1.setProtocolName(var2);
        int var3 = var1_1.attributeInt(null, "indent", -1);
        serviceDefinition.setIndentCount(var3);
        serviceDefinition.m_serviceName = var1_1.attributeText(null, "service-name", null);
        var1_1.popObject();
        return serviceDefinition;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ ServiceDefinition JiBX_service_mapping_unmarshal_1_0(ServiceDefinition arg1, UnmarshallingContext arg2) throws JiBXException {
        void var1_1;
        try {
            ServiceDefinition serviceDefinition;
            arg2.pushObject((Object)arg1);
            ServiceDefinition serviceDefinition2 = arg1;
            arg1.m_serviceClassName = arg2.parseElementText(null, "service-class");
            arg1.m_opdefs = JiBX_service_mappingMungeAdapter.JiBX_service_mapping_unmarshal_1_0(JiBX_service_mappingMungeAdapter.JiBX_service_mapping_newinstance_1_0((ArrayList)arg1.m_opdefs, arg2), arg2);
            if (arg2.isAt(null, "jibx-binding")) {
                arg2.parseToStartTag(null, "jibx-binding");
                BindingLocator var2 = BindingLocator.JiBX_service_mapping_unmarshalAttr_1_0(BindingLocator.JiBX_service_mapping_newinstance_1_0(null, arg2), arg2);
                arg1.setBindingLocator(var2);
                var1_1.parsePastStartTag(null, "jibx-binding");
                var1_1.parsePastCurrentEndTag(null, "jibx-binding");
            } else {
                BindingLocator var2 = null;
                serviceDefinition.setBindingLocator(var2);
            }
            if (var1_1.isAt(null, "jibx-in-binding")) {
                var1_1.parseToStartTag(null, "jibx-in-binding");
                BindingLocator var3 = BindingLocator.JiBX_service_mapping_unmarshalAttr_1_0(BindingLocator.JiBX_service_mapping_newinstance_1_0(null, (UnmarshallingContext)var1_1), (UnmarshallingContext)var1_1);
                serviceDefinition.setInBodyBindingLocator(var3);
                var1_1.parsePastStartTag(null, "jibx-in-binding");
                var1_1.parsePastCurrentEndTag(null, "jibx-in-binding");
            } else {
                BindingLocator var3 = null;
                serviceDefinition.setInBodyBindingLocator(var3);
            }
            if (var1_1.isAt(null, "jibx-out-binding")) {
                var1_1.parseToStartTag(null, "jibx-out-binding");
                BindingLocator var4 = BindingLocator.JiBX_service_mapping_unmarshalAttr_1_0(BindingLocator.JiBX_service_mapping_newinstance_1_0(null, (UnmarshallingContext)var1_1), (UnmarshallingContext)var1_1);
                serviceDefinition.setOutBodyBindingLocator(var4);
                var1_1.parsePastStartTag(null, "jibx-out-binding");
                var1_1.parsePastCurrentEndTag(null, "jibx-out-binding");
            } else {
                BindingLocator var4 = null;
                serviceDefinition.setOutBodyBindingLocator(var4);
            }
            serviceDefinition.m_hdefs = JiBX_service_mappingMungeAdapter.JiBX_service_mapping_unmarshal_1_2(JiBX_service_mappingMungeAdapter.JiBX_service_mapping_newinstance_1_0((ArrayList)serviceDefinition.m_hdefs, (UnmarshallingContext)var1_1), (UnmarshallingContext)var1_1);
            String var5 = var1_1.parseElementText(null, "output-completion-listener-class", null);
            serviceDefinition.setOutputCompletionListenerClassName(var5);
            String var6 = var1_1.parseElementText(null, "service-exception-handler-class", null);
            serviceDefinition.setServiceExceptionHandlerClassName(var6);
            if (var1_1.isAt(null, "fault")) {
                var1_1.parseToStartTag(null, "fault");
                serviceDefinition.m_includeStackTraceOnFault = var1_1.attributeBoolean(null, "include-stack-trace", false);
                var1_1.parsePastStartTag(null, "fault");
                var1_1.parsePastCurrentEndTag(null, "fault");
            } else {
                serviceDefinition2 = null;
            }
            if (var1_1.isAt(null, "wsdl")) {
                var1_1.parseToStartTag(null, "wsdl");
                serviceDefinition.m_wsdlFilepath = var1_1.attributeText(null, "file");
                serviceDefinition.m_wsdlLocationTransform = var1_1.attributeBoolean(null, "transformLocation", false);
                var1_1.parsePastStartTag(null, "wsdl");
                var1_1.parsePastCurrentEndTag(null, "wsdl");
            } else {
                serviceDefinition2 = null;
            }
            serviceDefinition.m_transportOptDefs = JiBX_service_mappingMungeAdapter.JiBX_service_mapping_unmarshal_1_3(JiBX_service_mappingMungeAdapter.JiBX_service_mapping_newinstance_1_0((ArrayList)serviceDefinition.m_transportOptDefs, (UnmarshallingContext)var1_1), (UnmarshallingContext)var1_1);
            var1_1.popObject();
            serviceDefinition.init();
            return serviceDefinition;
        }
        catch (WsBindingException | WsConfigurationException wsException) {
            throw new JiBXException(new StringBuffer("Error while unmarshalling ").append(var1_1.buildPositionString()).toString(), (Throwable)wsException);
        }
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller("org.jibx.ws.server.ServiceDefinition").unmarshal((Object)this, arg1);
    }

    public /* synthetic */ String JiBX_getName() {
        return "org.jibx.ws.server.ServiceDefinition";
    }
}

