/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.soap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jibx.runtime.QName;
import org.jibx.ws.WsException;
import org.jibx.ws.io.handler.OutHandler;
import org.jibx.ws.soap.SoapVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SoapFault
implements Serializable {
    public static final QName FAULT_CODE_CLIENT = new QName(null, "SOAP", "Client");
    public static final QName FAULT_CODE_SERVER = new QName(null, "SOAP", "Server");
    public static final QName FAULT_CODE_MUST_UNDERSTAND = new QName(null, "SOAP", "MustUnderstand");
    public static final QName FAULT_CODE_VERSION_MISMATCH = new QName(null, "SOAP", "VersionMismatch");
    private final QName m_faultCode;
    private final Map<Locale, String> m_reasonTexts = new LinkedHashMap<Locale, String>();
    private final String m_faultRole;
    private final List m_details = new ArrayList();
    private final List m_detailWriters = new ArrayList();
    private final List<QName> m_subcodes = new ArrayList<QName>();
    private final SoapVersion m_soapVersion;

    public SoapFault(QName faultCode, String faultString, String faultActor) throws WsException {
        if (faultCode == null || faultString == null) {
            throw new WsException("faultCode and faultString must be non-null");
        }
        this.m_soapVersion = SoapVersion.SOAP1_1;
        if (faultCode.getUri() == null && "SOAP".equals(faultCode.getPrefix())) {
            faultCode = new QName(this.getURI(), faultCode.getName());
        }
        if (faultCode.getUri() == null) {
            throw new WsException("faultCode URI must be non-null");
        }
        if (!faultCode.getUri().equals(this.getURI()) && faultCode.getPrefix() == null) {
            throw new WsException("faultCode prefix must be non-null for custom URIs");
        }
        this.m_faultCode = faultCode;
        this.m_reasonTexts.put(null, faultString);
        this.m_faultRole = faultActor;
    }

    public SoapFault(QName code, Collection<QName> subcodes, Map<Locale, String> reasons, String faultRole) throws WsException {
        if (code == null || reasons == null) {
            throw new WsException("code and reasons must be non-null");
        }
        if (reasons.isEmpty()) {
            throw new WsException("reasons must have one or more value");
        }
        this.m_soapVersion = SoapVersion.SOAP1_2;
        if (code.getUri() == null && "SOAP".equals(code.getPrefix())) {
            code = new QName(this.getURI(), code.getName());
        }
        if (code.getUri() == null) {
            throw new WsException("code URI must be non-null");
        }
        if (!code.getUri().equals(this.getURI())) {
            throw new WsException("code is not a standard value");
        }
        this.m_faultCode = code;
        if (subcodes != null) {
            this.m_subcodes.addAll(subcodes);
        }
        this.m_reasonTexts.putAll(reasons);
        this.m_faultRole = faultRole;
    }

    private String getURI() {
        return SoapVersion.SOAP1_1.equals(this.m_soapVersion) ? "http://schemas.xmlsoap.org/soap/envelope/" : "http://www.w3.org/2003/05/soap-envelope";
    }

    void addDetail(Object item) {
        this.m_details.add(item);
    }

    public void addDetailWriter(OutHandler writer) {
        this.m_detailWriters.add(writer);
    }

    public QName getFaultCode() {
        return this.m_faultCode;
    }

    public String getFaultString() {
        return this.m_reasonTexts.values().iterator().next();
    }

    public Locale getFaultStringLocale() {
        return this.m_reasonTexts.keySet().iterator().next();
    }

    public String getFaultActor() {
        return this.m_faultRole;
    }

    public Iterator<QName> getFaultSubcodes() {
        if (SoapVersion.SOAP1_1.equals(this.m_soapVersion)) {
            throw new UnsupportedOperationException("Not supported in SOAP 1.1");
        }
        return Collections.unmodifiableCollection(this.m_subcodes).iterator();
    }

    public String getFaultReasonText(Locale locale) {
        if (SoapVersion.SOAP1_1.equals(this.m_soapVersion)) {
            throw new UnsupportedOperationException("Not supported in SOAP 1.1");
        }
        return this.m_reasonTexts.get(locale);
    }

    public Iterator<String> getFaultReasonTexts() {
        if (SoapVersion.SOAP1_1.equals(this.m_soapVersion)) {
            throw new UnsupportedOperationException("Not supported in SOAP 1.1");
        }
        return Collections.unmodifiableCollection(this.m_reasonTexts.values()).iterator();
    }

    public Iterator<Locale> getFaultReasonLocales() {
        if (SoapVersion.SOAP1_1.equals(this.m_soapVersion)) {
            throw new UnsupportedOperationException("Not supported in SOAP 1.1");
        }
        return Collections.unmodifiableCollection(this.m_reasonTexts.keySet()).iterator();
    }

    public String getFaultRole() {
        if (SoapVersion.SOAP1_1.equals(this.m_soapVersion)) {
            throw new UnsupportedOperationException("Not supported in SOAP 1.1");
        }
        return this.m_faultRole;
    }

    public List getDetails() {
        return this.m_details;
    }

    public List getDetailWriters() {
        return this.m_detailWriters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getFaultCode().getPrefix() != null) {
            sb.append(this.getFaultCode().getPrefix()).append(":");
        } else if (this.getURI().equals(this.getFaultCode().getUri())) {
            sb.append("SOAP").append(":");
        } else if (this.getFaultCode().getUri() != null) {
            sb.append('{').append(this.getFaultCode().getUri()).append('}');
        }
        if (this.getFaultCode().getName() != null) {
            sb.append(this.getFaultCode().getName());
        }
        sb.append(" - ").append(this.getFaultString());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_details == null ? 0 : this.m_details.hashCode());
        result = 31 * result + (this.m_faultCode == null ? 0 : this.m_faultCode.hashCode());
        result = 31 * result + this.m_reasonTexts.hashCode();
        result = 31 * result + this.m_subcodes.hashCode();
        result = 31 * result + (this.m_faultRole == null ? 0 : this.m_faultRole.hashCode());
        result = 31 * result + this.m_soapVersion.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SoapFault other = (SoapFault)obj;
        if (!this.m_soapVersion.equals(other.m_soapVersion)) {
            return false;
        }
        if (this.m_details == null ? other.m_details != null : !this.m_details.equals(other.m_details)) {
            return false;
        }
        if (this.m_faultRole == null ? other.m_faultRole != null : !this.m_faultRole.equals(other.m_faultRole)) {
            return false;
        }
        if (this.m_faultCode == null ? other.m_faultCode != null : !this.m_faultCode.equals((Object)other.m_faultCode)) {
            return false;
        }
        if (!this.m_reasonTexts.equals(other.m_reasonTexts)) {
            return false;
        }
        return this.m_subcodes.equals(other.m_subcodes);
    }
}

