/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.soap;

import java.io.IOException;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.WsException;
import org.jibx.ws.codec.CodecDirectory;
import org.jibx.ws.codec.MediaType;
import org.jibx.ws.context.ExchangeContext;
import org.jibx.ws.io.MessageOptions;
import org.jibx.ws.process.Processor;
import org.jibx.ws.server.MediaTypeMapper;
import org.jibx.ws.server.Service;
import org.jibx.ws.server.ServiceDefinition;
import org.jibx.ws.server.ServiceExceptionHandler;
import org.jibx.ws.server.ServiceExceptionHandlerFactory;
import org.jibx.ws.server.ServiceFactory;
import org.jibx.ws.soap.SoapProcessor12;
import org.jibx.ws.soap.SoapProtocol;
import org.jibx.ws.soap.SoapVersion;
import org.jibx.ws.soap.server.SoapFaultHandler;
import org.jibx.ws.soap.server.SoapService;
import org.jibx.ws.transport.InConnection;
import org.jibx.ws.transport.MessageProperties;

final class SoapProtocol12
extends SoapProtocol {
    private static final MediaTypeMapper s_soap12MediaTypeMapper;
    private static final ServiceExceptionHandlerFactory s_exceptionHandlerFactoryWithTrace12;
    private static final ServiceExceptionHandlerFactory s_exceptionHandlerFactoryNoTrace12;
    private static final ServiceFactory s_service12Factory;

    private static ServiceExceptionHandlerFactory getDefaultExceptionHandlerFactory(boolean includeStackTrace) {
        if (includeStackTrace) {
            return s_exceptionHandlerFactoryWithTrace12;
        }
        return s_exceptionHandlerFactoryNoTrace12;
    }

    public SoapVersion getSoapVersion() {
        return SoapVersion.SOAP1_2;
    }

    public Processor createProcessor() {
        return new SoapProcessor12();
    }

    public Processor createProcessor(ExchangeContext exchangeContext) {
        return new SoapProcessor12(exchangeContext);
    }

    public ServiceFactory getServiceFactory() {
        return s_service12Factory;
    }

    public MediaTypeMapper getMediaTypeMapper() {
        return s_soap12MediaTypeMapper;
    }

    public MessageProperties buildMessageProperties(String opname, MessageOptions msgOptions) throws WsConfigurationException {
        String charset = msgOptions.getEncoding().toString();
        String outtype = msgOptions.getOutMediaTypeCode();
        String[] intypes = msgOptions.getInMediaTypeCodes();
        String[] acceptEncoding = msgOptions.getAcceptEncoding();
        MessageProperties props = new MessageProperties();
        props.setContentType(this.getMediaTypeMapper().getMediaTypeFor(outtype));
        MediaType[] acceptTypes = new MediaType[intypes.length];
        for (int i = 0; i < intypes.length; ++i) {
            acceptTypes[i] = this.getMediaTypeMapper().getMediaTypeFor(intypes[i]);
        }
        props.setAcceptTypes(acceptTypes);
        if (opname != null && opname.length() > 0) {
            props.setOperation(opname);
        }
        if (charset != null) {
            props.setCharset(charset);
        }
        if (acceptEncoding != null) {
            props.setAcceptEncoding(acceptEncoding);
        }
        return props;
    }

    public String getOperationName(InConnection conn) throws IOException {
        return conn.getOperationName();
    }

    static {
        s_exceptionHandlerFactoryWithTrace12 = new ServiceExceptionHandlerFactory(){

            public ServiceExceptionHandler createServiceExceptionHandler() {
                return new SoapFaultHandler(SoapVersion.SOAP1_2, true);
            }
        };
        s_exceptionHandlerFactoryNoTrace12 = new ServiceExceptionHandlerFactory(){

            public ServiceExceptionHandler createServiceExceptionHandler() {
                return new SoapFaultHandler(SoapVersion.SOAP1_2, false);
            }
        };
        s_service12Factory = new ServiceFactory(){

            public Service createInstance(ServiceDefinition sdef) throws WsException {
                return new SoapService(sdef, s_soap12MediaTypeMapper, new SoapProcessor12(), SoapProtocol12.getDefaultExceptionHandlerFactory(sdef.getIncludeStackTraceOnFault()));
            }
        };
        s_soap12MediaTypeMapper = new MediaTypeMapper(){

            public MediaType getMediaTypeFor(String code) throws WsConfigurationException {
                if (code == null || "xml".equals(code)) {
                    return CodecDirectory.APPLICATION_SOAP_XML_MEDIA_TYPE;
                }
                MediaType type = new MediaType("application", "soap+" + code);
                if (!CodecDirectory.hasCodecFor(type)) {
                    throw new WsConfigurationException("No codec available for media type '" + type + "' based on media type code '" + code + "' with protocol SOAP 1.2");
                }
                return type;
            }
        };
    }
}

