/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.soap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.QName;
import org.jibx.ws.WsException;
import org.jibx.ws.soap.SoapFault;
import org.jibx.ws.soap.SoapReader;
import org.jibx.ws.transport.InConnection;

public final class SoapReader12
extends SoapReader {
    SoapReader12(InConnection conn) throws IOException, WsException {
        super(conn, "http://www.w3.org/2003/05/soap-envelope");
    }

    public SoapFault startFault() throws WsException {
        try {
            ArrayList<QName> subcodes;
            this.m_wrapper.parsePastStartTag(this.m_uri, "Fault");
            this.m_wrapper.parsePastStartTag(this.m_uri, "Code");
            QName code = this.createQName(this.m_wrapper.parseElementText(this.m_uri, "Value"));
            if (this.m_wrapper.isAtStart(this.m_uri, "Subcode")) {
                subcodes = new ArrayList<QName>();
                while (this.m_wrapper.isAtStart(this.m_uri, "Subcode")) {
                    QName subcode = this.createQName(this.m_wrapper.parseElementText(this.m_uri, "Value"));
                    subcodes.add(subcode);
                }
            } else {
                subcodes = null;
            }
            this.m_wrapper.parsePastEndTag(this.m_uri, "Code");
            this.m_wrapper.parsePastStartTag(this.m_uri, "Reason");
            LinkedHashMap<Locale, String> reasons = new LinkedHashMap<Locale, String>();
            while (this.m_wrapper.isAtStart(this.m_uri, "Text")) {
                Locale locale = this.toLocale(this.m_wrapper.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang"));
                String text = this.m_wrapper.parseElementText(this.m_uri, "Text");
                reasons.put(locale, text);
            }
            this.m_wrapper.parsePastEndTag(this.m_uri, "Reason");
            String role = null;
            if (this.m_wrapper.isAtStart(this.m_uri, "Role")) {
                role = this.m_wrapper.parseElementText(this.m_uri, "Role");
            }
            return new SoapFault(code, subcodes, reasons, role);
        }
        catch (JiBXException e) {
            throw new WsException("Error reading start of fault.", e);
        }
    }

    private Locale toLocale(String lang) {
        if (null == lang) {
            return Locale.getDefault();
        }
        int p = lang.indexOf("-");
        if (-1 == p) {
            return new Locale(lang, lang);
        }
        return new Locale(lang.substring(0, p), lang.substring(p));
    }

    public boolean startFaultDetail() throws WsException {
        try {
            if (this.m_wrapper.isAtStart(this.m_uri, "Detail")) {
                this.m_wrapper.parsePastStartTag(this.m_uri, "Detail");
                return true;
            }
            return false;
        }
        catch (JiBXException e) {
            throw new WsException("Error reading start of fault detail.", e);
        }
    }

    public void endFaultDetail() throws WsException {
        try {
            this.m_wrapper.parsePastEndTag(this.m_uri, "Detail");
        }
        catch (JiBXException e) {
            throw new WsException("Error reading end of fault detail.", e);
        }
    }

    private QName createQName(String str) {
        QName qname = null;
        if (str != null) {
            int i = str.indexOf(58);
            if (i == -1) {
                qname = new QName(str);
            } else {
                String prefix = str.substring(0, i);
                String name = str.substring(i + 1);
                String uri = this.m_wrapper.getReader().getNamespace(prefix);
                qname = new QName(uri, prefix, name);
            }
        }
        return qname;
    }
}

