/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.soap.server;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.ws.io.handler.ExceptionWriter;
import org.jibx.ws.process.Processor;
import org.jibx.ws.server.ServiceExceptionHandler;
import org.jibx.ws.soap.SoapFault;
import org.jibx.ws.soap.SoapFaultException;
import org.jibx.ws.soap.SoapProcessor;
import org.jibx.ws.soap.SoapVersion;
import org.jibx.ws.soap.WsNotUnderstoodException;
import org.jibx.ws.transport.OutServerConnection;

public final class SoapFaultHandler
implements ServiceExceptionHandler {
    private static final Log logger = LogFactory.getLog(SoapFaultHandler.class);
    private boolean m_includeStackTrace;
    private final SoapVersion m_soapVersion;

    public SoapFaultHandler(SoapVersion soapVersion, boolean includeStackTrace) {
        this.m_soapVersion = soapVersion;
        this.m_includeStackTrace = includeStackTrace;
    }

    public void handleException(Throwable e, Processor processor, OutServerConnection outConn) {
        logger.warn((Object)"Error processing request. Generating SOAP Fault response.", e);
        outConn.setInternalServerError();
        try {
            SoapFault fault;
            Throwable wrapped;
            if (e instanceof InvocationTargetException && (wrapped = ((InvocationTargetException)e).getTargetException()) != null) {
                e = wrapped;
            }
            SoapProcessor soapProcessor = (SoapProcessor)processor;
            if (e instanceof SoapFaultException) {
                fault = ((SoapFaultException)e).getFault();
            } else if (e instanceof WsNotUnderstoodException) {
                fault = SoapVersion.SOAP1_1.equals(this.m_soapVersion) ? new SoapFault(SoapFault.FAULT_CODE_MUST_UNDERSTAND, e.getMessage(), null) : new SoapFault(SoapFault.FAULT_CODE_MUST_UNDERSTAND, null, Collections.singletonMap(null, e.getMessage()), null);
            } else {
                fault = SoapVersion.SOAP1_1.equals(this.m_soapVersion) ? new SoapFault(SoapFault.FAULT_CODE_SERVER, e.getMessage(), null) : new SoapFault(SoapFault.FAULT_CODE_SERVER, null, Collections.singletonMap(null, e.getMessage()), null);
                if (this.m_includeStackTrace) {
                    fault.addDetailWriter(new ExceptionWriter(e, true));
                }
            }
            soapProcessor.sendFaultMessage(fault, outConn);
        }
        catch (Throwable ex) {
            logger.error((Object)"Error while processing prior error", ex);
        }
    }
}

