/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.soap.server;

import org.jibx.ws.WsException;
import org.jibx.ws.context.ExchangeContext;
import org.jibx.ws.context.InContext;
import org.jibx.ws.context.OutContext;
import org.jibx.ws.io.handler.InHandler;
import org.jibx.ws.io.handler.OutHandler;
import org.jibx.ws.process.Processor;
import org.jibx.ws.server.HandlerDefinition;
import org.jibx.ws.server.MediaTypeMapper;
import org.jibx.ws.server.Service;
import org.jibx.ws.server.ServiceDefinition;
import org.jibx.ws.server.ServiceExceptionHandlerFactory;
import org.jibx.ws.soap.SoapPhase;
import org.jibx.ws.wsdl.WsdlProvider;

public final class SoapService
extends Service {
    private WsdlProvider m_wsdlProvider;

    public SoapService(ServiceDefinition sdef, MediaTypeMapper mediaTypeMapper, Processor processor, ServiceExceptionHandlerFactory defaultExceptionHandlerFactory) throws WsException {
        super(sdef, processor, mediaTypeMapper, defaultExceptionHandlerFactory);
        processor.setExchangeContext(this.createExchangeContext(sdef));
    }

    private ExchangeContext createExchangeContext(ServiceDefinition sdef) throws WsException {
        InContext inCtx = new InContext();
        OutContext outCtx = new OutContext();
        this.createBodyHandlers(inCtx, outCtx);
        this.createHeaderHandlers(sdef, outCtx, inCtx);
        this.setContextOnTransportOptions(inCtx, outCtx);
        return ExchangeContext.createInOutExchange(inCtx, outCtx);
    }

    private void createHeaderHandlers(ServiceDefinition sdef, OutContext outCtx, InContext inCtx) throws WsException {
        if (sdef.getHandlerDefinitions() != null) {
            for (int i = 0; i < sdef.getHandlerDefinitions().size(); ++i) {
                HandlerDefinition hdef = (HandlerDefinition)sdef.getHandlerDefinitions().get(i);
                Object handler = hdef.getObject();
                if (handler instanceof InHandler) {
                    inCtx.addHandler(SoapPhase.HEADER, (InHandler)handler);
                    continue;
                }
                if (!(handler instanceof OutHandler)) continue;
                outCtx.addHandler(SoapPhase.HEADER, (OutHandler)handler);
            }
        }
    }

    public void setWsdlProvider(WsdlProvider wsdlProvider) {
        this.m_wsdlProvider = wsdlProvider;
    }

    public WsdlProvider getWsdlProvider() {
        return this.m_wsdlProvider;
    }
}

