/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.tcp.client;

import java.io.IOException;
import java.net.Socket;
import java.text.ParseException;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.impl.IInByteBuffer;
import org.jibx.runtime.impl.IOutByteBuffer;
import org.jibx.runtime.impl.InByteBuffer;
import org.jibx.runtime.impl.OutByteBuffer;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.codec.CodecCache;
import org.jibx.ws.codec.CodecDirectory;
import org.jibx.ws.codec.MediaType;
import org.jibx.ws.encoding.dime.DimeInputBuffer;
import org.jibx.ws.encoding.dime.DimeOutputBuffer;
import org.jibx.ws.io.XmlOptions;
import org.jibx.ws.transport.Channel;
import org.jibx.ws.transport.DuplexConnection;
import org.jibx.ws.transport.InConnection;
import org.jibx.ws.transport.MessageProperties;
import org.jibx.ws.transport.OutConnection;
import org.jibx.ws.transport.OutConnectionBase;
import org.jibx.ws.transport.SimpleDuplexConnection;

public final class TcpChannel
implements Channel {
    private static final String TCP_LEAD = "tcp://";
    private final String m_endpoint;
    private Socket m_socket;
    private DimeInputBuffer m_dimeInput;
    private DimeOutputBuffer m_dimeOutput;
    private final CodecCache m_codecCache;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected TcpChannel(String endpoint) throws WsConfigurationException {
        if (!endpoint.toLowerCase().startsWith(TCP_LEAD)) throw new IllegalArgumentException("Endpoint '" + endpoint + "' is not using the tcp protocol");
        this.m_endpoint = endpoint;
        int split = (endpoint = endpoint.substring(TCP_LEAD.length())).indexOf(58);
        if (split <= 0) throw new WsConfigurationException("Missing port number in endpoint '" + endpoint + '\'');
        String host = endpoint.substring(0, split);
        endpoint = endpoint.substring(split + 1);
        split = endpoint.indexOf(47);
        String port = null;
        port = split >= 0 ? endpoint.substring(0, split) : endpoint;
        try {
            int portnum = Integer.parseInt(port);
            this.m_socket = new Socket(host, portnum);
            this.m_socket.setTcpNoDelay(true);
        }
        catch (NumberFormatException e) {
            throw new WsConfigurationException("Error parsing port number for endpoint '" + endpoint + '\'', e);
        }
        catch (IOException e) {
            throw new WsConfigurationException("Unable to create socket connection to endpoint '" + endpoint + '\'', e);
        }
        this.m_codecCache = new CodecCache();
    }

    private void setupOutput(MessageProperties msgProps) throws IOException {
        MediaType type;
        if (this.m_dimeOutput == null) {
            this.m_dimeOutput = new DimeOutputBuffer();
            OutByteBuffer obuff = new OutByteBuffer();
            this.m_dimeOutput.setBuffer((IOutByteBuffer)obuff);
            obuff.setOutput(this.m_socket.getOutputStream());
        }
        int typecode = (type = msgProps.getContentType()) == null ? 64 : 16;
        this.m_dimeOutput.nextMessage();
        this.m_dimeOutput.nextPart(null, typecode, type == null ? null : type.toString());
    }

    public InConnection getInbound() {
        return new TcpInConnection();
    }

    public OutConnection getOutbound(MessageProperties msgProps, XmlOptions xmlOptions) throws IOException {
        this.setupOutput(msgProps);
        return new TcpOutConnection(msgProps, xmlOptions);
    }

    public DuplexConnection getDuplex(MessageProperties msgProps, XmlOptions xmlOptions) throws IOException {
        this.setupOutput(msgProps);
        return new SimpleDuplexConnection(new TcpInConnection(), new TcpOutConnection(msgProps, xmlOptions));
    }

    public void close() throws IOException {
        this.m_socket.close();
    }

    private class TcpOutConnection
    extends OutConnectionBase {
        private final MessageProperties m_msgProps;
        private boolean m_initialized;
        private IXMLWriter m_writer;

        public TcpOutConnection(MessageProperties msgProps, XmlOptions xmlOptions) {
            super(xmlOptions);
            this.m_msgProps = msgProps;
        }

        public IXMLWriter getNormalWriter(String[] uris) throws IOException {
            if (!this.m_initialized) {
                this.m_writer = TcpChannel.this.m_codecCache.getCodec(this.m_msgProps.getContentType()).getWriter(TcpChannel.this.m_dimeOutput, null, uris);
                this.initializeWriter(this.m_writer);
                this.m_initialized = true;
            }
            return this.m_writer;
        }

        public IXMLWriter getFaultWriter(String[] uris) throws IOException {
            return this.getNormalWriter(uris);
        }

        public void outputComplete() {
        }

        public void close() throws IOException {
            if (this.m_initialized) {
                this.m_writer.flush();
                TcpChannel.this.m_dimeOutput.endMessage();
                TcpChannel.this.m_dimeOutput.flush();
            }
        }
    }

    private class TcpInConnection
    implements InConnection {
        private boolean m_initialized;
        private IXMLReader m_reader;

        private TcpInConnection() {
        }

        private void checkInitialized() {
            if (!this.m_initialized) {
                throw new IllegalStateException("Internal error - connection not initialized");
            }
        }

        public void init() throws IOException {
            if (!this.m_initialized) {
                if (TcpChannel.this.m_dimeInput == null) {
                    TcpChannel.this.m_dimeInput = new DimeInputBuffer();
                    InByteBuffer ibuff = new InByteBuffer();
                    TcpChannel.this.m_dimeInput.setBuffer((IInByteBuffer)ibuff);
                    ibuff.setInput(TcpChannel.this.m_socket.getInputStream());
                }
                if (TcpChannel.this.m_dimeInput.nextMessage() && TcpChannel.this.m_dimeInput.nextPart()) {
                    MediaType mediaType = null;
                    if (TcpChannel.this.m_dimeInput.getPartTypeCode() == 16) {
                        String partTypeText = TcpChannel.this.m_dimeInput.getPartTypeText();
                        try {
                            MediaType partMediaType = new MediaType(partTypeText);
                            if (CodecDirectory.hasCodecFor(partMediaType)) {
                                mediaType = partMediaType;
                            }
                        }
                        catch (ParseException e) {
                            throw new IOException("Unable to parse media type '" + partTypeText + "'");
                        }
                    }
                    if (mediaType == null) {
                        mediaType = CodecDirectory.TEXT_XML_MEDIA_TYPE;
                    }
                    this.m_reader = TcpChannel.this.m_codecCache.getCodec(mediaType).getReader(TcpChannel.this.m_dimeInput, null, TcpChannel.this.m_endpoint, false);
                    this.m_reader.init();
                    this.m_initialized = true;
                } else {
                    throw new IOException("No data present");
                }
            }
        }

        public String getCharacterEncoding() {
            this.checkInitialized();
            return this.m_reader.getInputEncoding();
        }

        public String getContentType() {
            this.checkInitialized();
            if (TcpChannel.this.m_dimeInput.getPartTypeCode() == 16) {
                return TcpChannel.this.m_dimeInput.getPartTypeText();
            }
            return null;
        }

        public String getDestination() {
            return null;
        }

        public String getId() {
            this.checkInitialized();
            return TcpChannel.this.m_dimeInput.getPartIdentifier();
        }

        public String getOperationName() {
            return null;
        }

        public String getOrigin() {
            return null;
        }

        public String getProperty(String name) {
            return null;
        }

        public IXMLReader getReader() {
            this.checkInitialized();
            return this.m_reader;
        }

        public boolean hasError() throws IOException {
            return false;
        }

        public String getErrorMessage() throws IOException {
            return null;
        }

        public void inputComplete() {
        }

        public void close() throws IOException {
            if (TcpChannel.this.m_dimeInput != null) {
                TcpChannel.this.m_dimeInput.finish();
            }
            this.m_reader = null;
        }
    }
}

