/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.transport;

import java.io.IOException;
import org.jibx.runtime.IXMLWriter;
import org.jibx.ws.io.XmlOptions;
import org.jibx.ws.transport.OutConnection;

public abstract class OutConnectionBase
implements OutConnection {
    private int m_indentCount;
    private char m_indentChar;
    private String m_newline;
    private boolean m_includeDecl;
    private String m_charEncoding;
    private String m_standaloneText;

    public OutConnectionBase(XmlOptions opts) {
        this.setIndentSpaces(opts.getIndentCount(), opts.getNewLine(), opts.getIndentChar());
        boolean incl = opts.getEncodingDeclString() != null || opts.getStandaloneDeclString() != null;
        this.setXmlDeclaration(incl, opts.getEncodingDeclString(), opts.getStandaloneDeclString());
    }

    public void setIndentSpaces(int count, String newline, char indent) {
        this.m_indentCount = count;
        this.m_newline = newline;
        this.m_indentChar = indent;
    }

    public void setXmlDeclaration(boolean incl, String charcode, String standalone) {
        this.m_includeDecl = incl;
        this.m_charEncoding = charcode;
        this.m_standaloneText = standalone;
    }

    protected void initializeWriter(IXMLWriter writer) throws IOException {
        writer.init();
        writer.setIndentSpaces(this.m_indentCount, this.m_newline, this.m_indentChar);
        if (this.m_includeDecl) {
            writer.writeXMLDecl("1.0", this.m_charEncoding, this.m_standaloneText);
        }
    }
}

