/*
 * Decompiled with CFR 0.152.
 */
package com.github.rwitzel.streamflyer.util;

import com.github.rwitzel.streamflyer.core.ModifyingReader;
import com.github.rwitzel.streamflyer.regex.RegexModifier;
import com.github.rwitzel.streamflyer.xml.InvalidXmlCharacterModifier;
import com.github.rwitzel.streamflyer.xml.XmlVersionModifier;
import com.github.rwitzel.streamflyer.xml.XmlVersionReader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.input.XmlStreamReader;

public class ModifyingReaderFactory {
    public ModifyingReader createInvalidXmlCharacterRemovingReader(InputStream xmlStream) throws IOException {
        return this.createInvalidXmlCharacterReplacingReader(xmlStream, "");
    }

    public ModifyingReader createInvalidXmlCharacterReplacingReader(InputStream xmlStream, String replacement) throws IOException {
        if (!(xmlStream instanceof BufferedInputStream)) {
            xmlStream = new BufferedInputStream(xmlStream);
        }
        XmlStreamReader xmlReader = new XmlStreamReader(xmlStream);
        XmlVersionReader xmlVersionReader = new XmlVersionReader((Reader)xmlReader);
        String xmlVersion = xmlVersionReader.getXmlVersion();
        boolean dollarZero = replacement.contains("$0");
        InvalidXmlCharacterModifier modifier = new InvalidXmlCharacterModifier(8192, replacement, xmlVersion, dollarZero);
        return new ModifyingReader(xmlVersionReader, modifier);
    }

    public ModifyingReader createXmlVersionModifyingReader(InputStream xmlStream, String newXmlVersion) throws IOException {
        if (!(xmlStream instanceof BufferedInputStream)) {
            xmlStream = new BufferedInputStream(xmlStream);
        }
        XmlStreamReader xmlReader = new XmlStreamReader(xmlStream);
        XmlVersionReader xmlVersionReader = new XmlVersionReader((Reader)xmlReader);
        XmlVersionModifier modifier = new XmlVersionModifier(newXmlVersion, 8192);
        return new ModifyingReader(xmlVersionReader, modifier);
    }

    public ModifyingReader createRegexModifyingReader(Reader input, String regex, String replacement) {
        return this.createRegexModifyingReader(input, regex, 0, replacement, 0, 8192);
    }

    public ModifyingReader createRegexModifyingReader(Reader input, String regex, int flags, String replacement, int minimumLengthOfLookBehind, int requestedCapacityOfCharacterBuffer) {
        if (!(input instanceof BufferedReader)) {
            input = new BufferedReader(input);
        }
        RegexModifier modifier = new RegexModifier(regex, flags, replacement, minimumLengthOfLookBehind, requestedCapacityOfCharacterBuffer);
        return new ModifyingReader(input, modifier);
    }
}

