package com.gridnine.xtrip.server.reports.templates

import com.gridnine.xtrip.common.l10n.model.L10nString
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.profile.Organization
import com.gridnine.xtrip.common.model.profile.OrganizationIndex
import com.gridnine.xtrip.common.model.profile.vip.Curator
import com.gridnine.xtrip.common.model.profile.vip.CuratorRole
/*****************************************************************
 * Gridnine AB http://www.gridnine.com
 * Project: BOF VIP-Service
 *
 * $Id: $
 *****************************************************************/
//File
class Table {
    static final String TITLE_H1 = 'titleH1'
    static final String TITLE = 'title'
    static final String TITLE_H3 = 'titleH3'
    static final String HEADER = 'header'
    static final String COLUMN_HEADER = 'columnHeader'
    static final String DATA = 'data'
    static final String DATA_TEXT = 'dataText'
    static final COL_WIDTH = 20
    def bind
    def boolToCellMap = [(true):'да', (false):'нет']

    Table(bind){
        this.bind = bind
        createStyles()
        renderHeader()
    }

    private void createStyles(){
        bind.createStyle(name: TITLE, v_alignment: 'CENTER')
        bind.createStyle(name: TITLE_H1, fontHeight: 16, parent: TITLE)
        bind.createStyle(name: TITLE_H3, fontHeight: 10, parent: TITLE,  wrapText: true)
        bind.createStyle(name: HEADER, fontHeight: 10, v_alignment: 'CENTER', topBorder: 'THIN', leftBorder: 'THIN', bottomBorder: 'THIN', rightBorder: 'THIN')
        bind.createStyle(name: COLUMN_HEADER, fontBold: true, wrapText: true, h_alignment: 'CENTER', parent: HEADER)
        bind.createStyle(name: DATA, fontHeight: 8, v_alignment: 'CENTER', topBorder: 'THIN', leftBorder: 'THIN', bottomBorder: 'THIN', rightBorder: 'THIN')
        bind.createStyle(name: DATA_TEXT, parent: DATA)
    }

    private void renderHeader(){
        // Set defalt row height
        bind.rowHeight(13.2)
        // Header
        bind.rowHeight(30, false)
        bind.nextColumn()
        bind.columnWidth(COL_WIDTH)
        bind.text('Отчет по кураторам', TITLE_H1)
        bind.nextRow()
        bind.rowHeight(40, false)
        bind.nextColumn()
        bind.columnWidth(COL_WIDTH)
        bind.text('Дата составления отчета:', TITLE_H3)
        bind.nextColumn()
        bind.columnWidth(COL_WIDTH)
        bind.text(new Date().format( 'yyyy-MM-dd' ), TITLE_H3)
        2.times{bind.nextRow()}
        bind.rowHeight(40, false)
        bind.nextColumn()
        bind.columnWidth(COL_WIDTH)
        bind.text('Заблокировано', COLUMN_HEADER)
        bind.nextColumn()
        bind.columnWidth(COL_WIDTH)
        bind.text('Временно заблокировано', COLUMN_HEADER)
        bind.nextColumn()
        bind.columnWidth(COL_WIDTH)
        bind.text('Код МОМ', COLUMN_HEADER)
        bind.nextColumn()
        bind.columnWidth(COL_WIDTH)
        bind.text('Короткое название СА', COLUMN_HEADER)
        bind.nextColumn()
        bind.columnWidth(COL_WIDTH)
        bind.text('ИНН', COLUMN_HEADER)
        bind.nextColumn()
        bind.columnWidth(COL_WIDTH)
        CuratorRole.values().each {
            bind.text(it.toString(), COLUMN_HEADER)
            bind.nextColumn()
            bind.columnWidth(COL_WIDTH)
        }
        bind.nextRow()
    }

    void addRow(Object... values){
        values = values.flatten()
        bind.nextColumn()
        values.each {
            def value =''
            switch(it){
                case Boolean:
                    value = boolToCellMap[it]
                    break;
                case L10nString:
                    value = it.toString()
                    break;
                case null:
                    value = ''
                    break;
                default:
                    value= it
            }

            bind.text(value, DATA_TEXT)
            bind.nextColumn()
        }
        bind.nextRow()
    }
}


class Curators {
    private List<Curator> curators;
    private def roleMap = [:]
    private static int len = CuratorRole.values().length
    private String[] result = new String[len]

    def Curators(Organization org ){
        this.curators = org.curators
        this.roleMap = curators.groupBy({curator-> curator.role});

    }

    String[] getCurators() {
        if (!curators) return result
        int i = 0;
        CuratorRole.values().each {
            if (roleMap.containsKey(it)){
                result[i++] = roleMap[it].collect({curator -> curator.curator?.caption}).join(', ')
            }
        }
        return result
    }
}




page{'Отчет по кураторам'}{

    table = new Table(this)
    EntityStorage storage = EntityStorage.get();

    tickets {
        OrganizationIndex indexOrg = (OrganizationIndex)it
        Organization org = storage.resolve(indexOrg.source).getEntity();
        def curators = new Curators(org)
        table.addRow(org.blackList, org.blocked, org.code,
                org.shortName, org.registrationId,   curators.getCurators())
    }
}

