// Imports
import com.gridnine.xtrip.common.l10n.model.LocaleHelper

import java.text.SimpleDateFormat

// Styles
createStyle(name: 'title', h_alignment: 'CENTER', v_alignment: 'CENTER', fontFamily: "TimesNewRoman")
createStyle(name: 'titleH1', fontHeight: 14, parent: 'title')
createStyle(name: 'titleH2', fontHeight: 12, parent: 'title')
createStyle(name: 'titleH3', fontHeight: 10, parent: 'title')
createStyle(name: 'header', h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight: 10, fontFamily: "TimesNewRoman")
createStyle(name: 'columnHeader', h_alignment: 'CENTER', parent: 'header')
createStyle(name: 'rowHeader', parent: 'header')
createStyle(name: 'data', h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight: 9, fontFamily: "TimesNewRoman")
createStyle(name: 'dataText', parent: 'data')
createStyle(name: 'dataNumber', format: '#,##0.00', parent: 'data')
createStyle(name: 'wrap', wrapText: true)
createStyle(name: 'ahl', h_alignment: 'LEFT')
createStyle(name: 'ahc', h_alignment: 'CENTER')
createStyle(name: 'ahr', h_alignment: 'RIGHT')
createStyle(name: 'avt', v_alignment: 'TOP')
createStyle(name: 'avc', v_alignment: 'CENTER')
createStyle(name: 'avb', v_alignment: 'BOTTOM')
createStyle(name: 'aac', h_alignment: 'CENTER', v_alignment: 'CENTER')
createStyle(name: 'bold', fontBold: true)
createStyle(name: 'italic', fontItalic: true)
createStyle(name: 'bt', topBorder: 'THICK')
createStyle(name: 'bl', leftBorder: 'THICK')
createStyle(name: 'bb', bottomBorder: 'THICK')
createStyle(name: 'br', rightBorder: 'THICK')
createStyle(name: 'ba', topBorder: 'THICK', leftBorder: 'THICK', bottomBorder: 'THICK', rightBorder: 'THICK')

// Closures
def date = {
    SimpleDateFormat format = new SimpleDateFormat("\"dd\" MMMM yyyy год", LocaleHelper.RU_LOCALE)
    return format.format(new Date())
}

page { 'Реестр отчетов' } {

    // Set portrait mode
    landscape(true)

    // Set narrow margins
    margin(0.25, 0.25, 0.75, 0.75)

    // Set scale
    scale(100)

    // Set preserve mode
    preserve(true)


// Report header
    rowHeight(17)
    2.times { nextRow() }
    nextColumn()
    text('Форма № 3. / Form No 3', 'dataText')
    nextRow()
    text('Движение БСО', 'titleH3|bold|br|bt|bl', 13, 1)
    nextRow()
    text('TICKET EXPENDITURE LIST  (paper form)', 'titleH3|italic|br|bb|bl', 13, 1)
    nextRow()

    text('Авиакомпания:', 'header|bt|br|bl', 3, 1)
    3.times { nextColumn() }
    text('', 'header|ba', 2, 2)
    2.times { nextColumn() }
    text('', 'header|bt|br|bl', 1, 1)
    nextColumn()
    text('', 'data|ba', 3, 2)
    3.times { nextColumn() }
    text('', 'data|bt|br|bl', 2, 1)
    2.times { nextColumn() }
    text('', 'data|ba', 2, 2)
    nextRow()
    text('Airline:', 'header|italic|bb|br|bl', 3, 1)
    5.times { nextColumn() }
    text('', 'data|bold|italic|bb|br|bl', 1, 1)
    4.times { nextColumn() }
    text('', 'data|bold|italic|bb|br|bl', 2, 1)
    nextRow()

    text('Агент:', 'header|bt|br|bl', 3, 1)
    3.times { nextColumn() }
    text('', 'header|bold|ba', 2, 2)
    2.times { nextColumn() }
    text('', 'header|bold|bt|br|bl', 1, 1)
    nextColumn()
    text('', 'data|bold|ba', 3, 2)
    3.times { nextColumn() }
    text('', 'data|bold|bt|br|bl', 2, 1)
    2.times { nextColumn() }
    text('', 'data|bold|ba', 2, 2)
    nextRow()
    text('Agent:', 'header|italic|bb|br|bl', 3, 1)
    5.times { nextColumn() }
    text('', 'data|bold|italic|bb|br|bl', 1, 1)
    4.times { nextColumn() }
    text('', 'data|bold|italic|bb|br|bl', 2, 1)
    nextRow()

    text('Страна:', 'header|bt|br|bl', 3, 1)
    3.times { nextColumn() }
    text('', 'header|bold|ba', 2, 2)
    2.times { nextColumn() }
    text('', 'header|bold|bt|br|bl', 1, 1)
    nextColumn()
    text('', 'data|bold|ba', 3, 2)
    3.times { nextColumn() }
    text('', 'data|bold|bt|br|bl', 2, 1)
    2.times { nextColumn() }
    text('', 'data|bold|ba', 2, 2)
    nextRow()
    text('Country:', 'header|italic|bb|br|bl', 3, 1)
    5.times { nextColumn() }
    text('', 'data|bold|italic|bb|br|bl', 1, 1)
    4.times { nextColumn() }
    text('', 'data|bold|italic|bb|br|bl', 2, 1)
    nextRow()

    text('Контактный тел/факс:', 'header|bold|bt|br|bl', 3, 2)
    3.times { nextColumn() }
    text('', 'header|bold|ba', 2, 2)
    2.times { nextColumn() }
    text('', 'header|bold|bt|br|bl', 1, 1)
    nextColumn()
    text('', 'header|bold|ba', 3, 2)
    3.times { nextColumn() }
    text('', 'header|bold|bt|br|bl', 2, 1)
    2.times { nextColumn() }
    text('', 'header|bold|ba', 2, 2)
    nextRow()
    9.times { nextColumn() }
    text('', 'header|bold|italic|bb|br|bl', 2, 1)
    nextRow()
    text('', 'titleH3|bold|br|bt|bl', 13, 1)
    nextRow()

// Table header
    text('Тип БСО', 'columnHeader|bt|br|bl', 1, 1)
    nextColumn()
    text('Остаток', 'columnHeader|bold|bt|br|bl', 3, 1)
    3.times { nextColumn() }
    text('Приход', 'columnHeader|bold|bt|br|bl', 3, 1)
    3.times { nextColumn() }
    text('Расход', 'columnHeader|bold|bt|br|bl', 3, 1)
    3.times { nextColumn() }
    text('Остаток', 'columnHeader|bold|bt|br|bl', 3, 1)
    3.times { nextColumn() }
    nextRow()

    rowHeight(34)
    text('Type of ticket', 'columnHeader|wrap|italic|br|bl', 1, 1)
    nextColumn()
    text('Balance', 'columnHeader|italic|bb|br|bl', 3, 1)
    3.times { nextColumn() }
    text('Receipts', 'columnHeader|italic|bb|br|bl', 3, 1)
    3.times { nextColumn() }
    text('Expenses', 'columnHeader|italic|bb|br|bl', 3, 1)
    3.times { nextColumn() }
    text('Balance', 'columnHeader|bb|br|bl', 3, 1)
    3.times { nextColumn() }
    nextRow()

    rowHeight(17)
    text('', 'columnHeader|br|bl', 1, 1)
    nextColumn()
    4.times {
        text('Номер БСО', 'columnHeader|bt|br|bl', 2, 1)
        2.times { nextColumn() }
        text('Кол-во', 'columnHeader|bt|br|bl', 1, 1)
        nextColumn()
    }
    nextRow()

    text('', 'columnHeader|br|bl', 1, 1)
    nextColumn()
    4.times {
        text('Number of ticket', 'columnHeader|italic|bb|br|bl', 2, 1)
        2.times { nextColumn() }
        text('Quantity', 'columnHeader|italic|br|bl', 1, 1)
        nextColumn()
    }
    nextRow()

    rowHeight(34)
    text('', 'columnHeader|br|bl', 1, 1)
    nextColumn()
    4.times {
        text('Начальный', 'columnHeader|bt|br|bl', 1, 1)
        nextColumn()
        text('Конечный', 'columnHeader|bt|br|bl', 1, 1)
        nextColumn()
        text('', 'columnHeader|br|bl', 1, 1)
        nextColumn()
    }
    nextRow()

    rowHeight(17)
    text('', 'columnHeader|italic|bb|br|bl', 1, 1)
    nextColumn()
    4.times {
        text('first', 'columnHeader|italic|bb|br|bl', 1, 1)
        nextColumn()
        text('final', 'columnHeader|italic|bb|br|bl', 1, 1)
        nextColumn()
        text('', 'columnHeader|italic|bb|br|bl', 1, 1)
        nextColumn()
    }
    nextRow()

    text('E-TKT', 'dataText|ba', 1, 7)
    3.times {
        12.times {
            nextColumn()
            text('', 'dataText|ba', 1, 1)
        }
        nextRow()
    }

    4.times {
        nextColumn()
        text('Итого E-TKT', 'dataText|bt|br|bl', 2, 1)
        2.times { nextColumn() }
        text('', 'dataText|ba', 1, 2)
    }
    nextRow()

    4.times {
        nextColumn()
        text('Total E-TKT', 'dataText|italic|bb|br|bl', 2, 1)
        2.times { nextColumn() }
    }
    nextRow()

    4.times {
        nextColumn()
        text('Всего:', 'dataText|bt|br|bl', 2, 1)
        2.times { nextColumn() }
        text('', 'dataText|ba', 1, 2)
    }
    nextRow()

    4.times {
        nextColumn()
        text('Total:', 'dataText|italic|bb|br|bl', 2, 1)
        2.times { nextColumn() }
    }
    nextRow()

    text('MCO 401', 'dataText|ba', 1, 7)
    5.times {
        12.times {
            nextColumn()
            text('', 'dataText|ba', 1, 1)
        }
        nextRow()
    }

    4.times {
        nextColumn()
        text('Итого 401', 'dataText|bt|br|bl', 2, 1)
        2.times { nextColumn() }
        text('', 'dataText|ba', 1, 2)
    }
    nextRow()

    4.times {
        nextColumn()
        text('Total 401', 'dataText|italic|bb|br|bl', 2, 1)
        2.times { nextColumn() }
    }
    nextRow()

    text('EBT 451', 'dataText|ba', 1, 5)
    3.times {
        12.times {
            nextColumn()
            text('', 'dataText|ba', 1, 1)
        }
        nextRow()
    }

    4.times {
        nextColumn()
        text('Итого 451', 'dataText|bt|br|bl', 2, 1)
        2.times { nextColumn() }
        text('', 'dataText|ba', 1, 2)
    }
    nextRow()

    4.times {
        nextColumn()
        text('Total 451', 'dataText|italic|bb|br|bl', 2, 1)
        2.times { nextColumn() }
    }
    nextRow()

    text('EMD', 'dataText|ba', 1, 5)
    3.times {
        12.times {
            nextColumn()
            text('', 'dataText|ba', 1, 1)
        }
        nextRow()
    }

    4.times {
        nextColumn()
        text('Итого EMD', 'dataText|bt|br|bl', 2, 1)
        2.times { nextColumn() }
        text('', 'dataText|ba', 1, 2)
    }
    nextRow()

    4.times {
        nextColumn()
        text('Total EMD', 'dataText|italic|bb|br|bl', 2, 1)
        2.times { nextColumn() }
    }
    nextRow()

    text('AWB', 'dataText|ba', 1, 5)
    3.times {
        12.times {
            nextColumn()
            text('', 'dataText|ba', 1, 1)
        }
        nextRow()
    }

    4.times {
        nextColumn()
        text('Итого AWB', 'dataText|bt|br|bl', 2, 1)
        2.times { nextColumn() }
        text('', 'dataText|ba', 1, 2)
    }
    nextRow()

    4.times {
        nextColumn()
        text('Total AWB', 'dataText|italic|bb|br|bl', 2, 1)
        2.times { nextColumn() }
    }
    4.times { nextRow() }

    text('ПОДПИСИ СТОРОН', 'titleH2|bold', 13, 1)
    nextRow()
    text('ПЕРЕВОЗЧИК', 'titleH2', 2, 1)
    7.times { nextColumn() }
    text('АГЕНТ', 'titleH2', 2, 1)
    nextRow()
    text('_______________/                        /', 'titleH2', 3, 1)
    7.times { nextColumn() }
    text('_______________/                        /', 'titleH2', 3, 1)
    2.times { nextRow() }
    text(date(), 'titleH2', 4, 1)
    6.times { nextColumn() }
    text(date(), 'titleH2', 4, 1)

    nextRow()
    nextColumn()
    4.times {
        columnWidth(12)
        3.times { nextColumn() }
    }
}