import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicketType
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNRefundReportTicket;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNReportHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNTransportationType
import com.gridnine.xtrip.server.reports.salesreports.render.nn.NNReportTestBase;;

//CREATING STYLES
createStyle(name: 'title',fontBold: true, h_span: 14, h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:20)
createStyle(name: 'subTitleLabel',fontBold: true, h_span: 2, h_alignment: 'RIGHT', v_alignment: 'CENTER', fontHeight:10)
createStyle(name: 'subTitleData',fontBold: false,  h_alignment: 'LEFT', v_alignment: 'CENTER', fontHeight:10)
createStyle(name: 'header',fontBold: false,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:10, leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM', wrapText: true)
createStyle(name: 'data',fontBold: false,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:10, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN')
createStyle(name: 'textData',parent: 'data')
createStyle(name: 'numberData',parent: 'data',h_alignment: 'RIGHT')
createStyle(name: 'dateData',parent: 'data',h_alignment: 'RIGHT',format: 'm/d/yy')
createStyle(name: 'totalTitle', parent: 'header', h_span: 6, h_alignment: 'RIGHT', fontBold: true)
createStyle(name: 'totalNumber',parent: 'totalTitle',  h_span: 1)



NNTransportationType transportationType = NNTransportationType.valueOf(parameters['transportationType'])
def tickets = []
allTickets.each { AirTicketsTemplateReportTicket ticket ->
    if(ticket.type == AirTicketsTemplateReportTicketType.MEMO) {
        return;
    }
    NNTransportationType tt = NNReportHelper.getTransportationType(ticket)
    if(tt != transportationType) {
        return;
    } 
    tickets.addAll(NNRefundReportTicket.createRefundTickets(ticket))
}

def title(NNTransportationType transportationType) {
    if(transportationType == NNTransportationType.VVL) {
        return "Возврат ВВЛ"
    }
    if(transportationType == NNTransportationType.MVL) {
        return "Возврат МВЛ"
    }
    return "Возврат Крым"
}
def footer = {
    nextRow()
    rowHeight(12)
    nextRow()
    text("Исполнил", 'subTitleLabel');
    nextRow()
    nextRow()
    text("Подпись", 'subTitleLabel');
}
//REPORT
page{parameters['title']}{
    //title
    rowHeight(30)
    text(title(transportationType),'title')
    nextRow()
    nextRow()
    rowHeight(15)
    text("Субагент", 'subTitleLabel')
    nextColumn()
    text(parameters['AGENCY_NAME'], 'subTitleData')
    nextRow()
    text("Период",'subTitleLabel')
    nextColumn()
    text(parameters['REPORT_PERIOD'], 'subTitleData')
    //header
    nextRow()
    nextRow()
    rowHeight(40);
    setStyle('header')
    text('Вид');nextColumn();
    columnWidth(20);
    text('Номер БПД');nextColumn();
    columnWidth(10);
    text('Дата возврата');nextColumn();
    text('Аэропорт вылета/прилета');nextColumn();
    text('Номер рейса');nextColumn();
    text('Дата вылета');nextColumn();
    text('Тариф');nextColumn();
    text('Сбор за бланк (вынужд. возврат)');nextColumn();
    text('Топливный сбор');nextColumn();
    text('% ком');nextColumn();
    text('Ком. Сбор');nextColumn();
    text('Итого');nextColumn();
    text('Штраф за возврат');nextColumn();
    text('код агентства');
    int rowCount = 0;
    tickets.each {NNRefundReportTicket ticket ->
        nextRow()
        rowHeight(15)
        text(ticket.type.toString(), 'textData');nextColumn();
        text(ticket.bpdNumer, 'textData');nextColumn();
        date(ticket.operationDate, 'dateData');nextColumn();
        columnWidth(15);
        text(ticket.airport, 'textData');nextColumn();
        columnWidth(10);
        text(ticket.flightNumber, 'textData');nextColumn();
        columnWidth(12);
        date(ticket.departureDate, 'dateData');nextColumn();
        columnWidth(10);
        number(ticket.equivalentFare, 'numberData');nextColumn();
        number(ticket.taxForBlank, 'numberData');nextColumn();
        number(ticket.taxForFuel, 'numberData');nextColumn();
        number(ticket.commissionRate, 'numberData');nextColumn();
        number(ticket.commissionValue, 'numberData');nextColumn();
        number(ticket.total, 'numberData');nextColumn();
        number(ticket.penalty, 'numberData');nextColumn();
        text(ticket.agencyCode, 'textData');
        rowCount++
    }
    nextRow();
    if(rowCount >0) {
        text("Итого", 'totalTitle');
        nextColumn()
        formula("SUM(G7:G${6+rowCount})", 'totalNumber')
        nextColumn()
        formula("SUM(H7:H${6+rowCount})", 'totalNumber')
        nextColumn()
        formula("SUM(I7:I${6+rowCount})", 'totalNumber')
        nextColumn()
        number(null, 'totalNumber')
        nextColumn()
        formula("SUM(K7:K${6+rowCount})", 'totalNumber')
        nextColumn()
        formula("SUM(L7:L${6+rowCount})", 'totalNumber')
        nextColumn()
        formula("SUM(M7:M${6+rowCount})", 'totalNumber')
        nextColumn()
        number(null, 'totalNumber')
        footer();
        return
    }
    rowHeight(15)
    text("Итого", 'totalTitle');
    nextColumn()
    number(null, 'totalNumber')
    nextColumn()
    number(null, 'totalNumber')
    nextColumn()
    number(null, 'totalNumber')
    nextColumn()
    number(null, 'totalNumber')
    nextColumn()
    number(null, 'totalNumber')
    nextColumn()
    number(null, 'totalNumber')
    nextColumn()
    number(null, 'totalNumber')
    nextColumn()
    number(null, 'totalNumber')
    footer();
}

