import com.gridnine.xtrip.common.l10n.model.LocaleHelper
import com.gridnine.xtrip.common.model.EntityReference
import com.gridnine.xtrip.common.model.booking.OperationBatch
import com.gridnine.xtrip.common.model.dict.DictionaryCache
import com.gridnine.xtrip.common.model.dict.DictionaryReference
import com.gridnine.xtrip.common.model.dict.GeoLocation
import com.gridnine.xtrip.common.model.dict.LocationType
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.helpers.SystemHelper
import com.gridnine.xtrip.common.model.profile.Address
import com.gridnine.xtrip.common.model.profile.Organization
import com.gridnine.xtrip.common.model.profile.SalesPoint
import com.gridnine.xtrip.common.model.system.MetadataKey
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket
import com.gridnine.xtrip.common.util.TextUtil

import java.text.SimpleDateFormat

createStyle(name: "left", h_alignment: "LEFT")
createStyle(name: "right", h_alignment: "RIGHT")
createStyle(name: "center", h_alignment: "CENTER")
createStyle(name: "left-bold", h_alignment: "LEFT", fontBold : true)
createStyle(name: "right-bold", h_alignment: "RIGHT", fontBold : true)
createStyle(name: "center-bold", h_alignment: "CENTER", fontBold : true)
createStyle(name: "center-center-bold", h_alignment: "CENTER", v_alignment: "CENTER", fontBold : true)
createStyle(name: "left-bold-border", h_alignment: "LEFT", fontBold : true, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "left-center-bold-border", h_alignment: "LEFT", v_alignment: "CENTER", fontBold : true, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "left-center-bold", h_alignment: "LEFT", v_alignment: "CENTER", fontBold : true)
createStyle(name: "right-bold-border", h_alignment: "RIGHT", fontBold : true, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-bold-border", h_alignment: "CENTER", fontBold : true, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "left-border", h_alignment: "LEFT", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "right-border", h_alignment: "RIGHT", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-border", h_alignment: "CENTER", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-center-border", h_alignment: "CENTER", v_alignment: "CENTER", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "right-center-border", h_alignment: "RIGHT", v_alignment: "CENTER", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "right-center-border-number", format: "#,##0.00", h_alignment: "RIGHT", v_alignment: "CENTER", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-center-bold-border", fontBold : true, h_alignment: "CENTER", v_alignment: "CENTER", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-border-number", h_alignment: "CENTER", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-center-border-number", format: "#,##0.00", h_alignment: "CENTER", v_alignment: "CENTER", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)

def printTitle() {
    rowHeight(30); text("Отчет о продаже организациям-клиентам", "center-center-bold", 15, 1)
    nextRow(); rowHeight(15)

    nextRow(); rowHeight(30); text("Агентство:", "left-bold", 2, 1)
    nextColumn(); nextColumn(); text(agencyCode(), "right")
    nextColumn(); text(parameters['AGENCY_NAME'], "left", 5, 1)
    6.times {
        nextColumn()
    }
    text("Период:", "left-bold")

    SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy")
    def periodBeginParameter = parameters['key-report-params']?.periodBegin
    def periodEndParameter = parameters['key-report-params']?.periodEnd

    nextColumn()
    text((periodBeginParameter ? sdf.format(periodBeginParameter) : "") +
            " - " +
            (periodEndParameter ? sdf.format(periodEndParameter) : ""),
            "left-bold", 2, 1)

    nextRow(); rowHeight(15); nextRow()
    text("Организация-клиент:", "left-bold", 2, 1)
    nextColumn(); nextColumn(); text("Министерство Внутренних Дел", "left-bold", 2, 1)

    nextRow(); rowHeight(5)

    nextRow(); rowHeight(15); text("Вид оплаты:", "left-bold", 2, 1)
    nextColumn(); nextColumn(); text("Воинское требование", "left", 2, 1)

    nextRow(); rowHeight(5)

    nextRow(); rowHeight(15); text("Валюта:", "left-bold", 2, 1)
    nextColumn(); nextColumn(); text("RUB", "left", 2, 1)

    nextRow(); rowHeight(5)

    nextRow(); rowHeight(15); text("Перевозчик:", "left-bold", 2, 1)
    nextColumn(); nextColumn(); text("А/К \"Сибирь\"", "left", 2, 1)

    nextRow(); nextRow()
    text("ВВЛ " + parameters['pageName'], "left-bold", 6, 1)
    nextRow(); text("TKT", "left-bold")
}

def agencyCode() {
    Organization agency = (Organization) EntityStorage.get().resolve(parameters['key-report-params']?.agency)?.entity

    String res = agency ? SystemHelper.findMetadataAsString(agency.getMetadata(), MetadataKey.KEY_S7_AGENCY_CODE) : null

    return res ? res : ''
}

def printHeader() {
    nextRow(); rowHeight(45)

    text("№ п/п", "center-center-bold-border", 1, 2)
    nextColumn(); text("3-х значный" + "\n" + "цифровой" + "\n" + "код ВПД", "center-center-bold-border", 1, 2)
    nextColumn(); text("№ ВПД", "center-center-bold-border", 1, 2)
    nextColumn(); text("№ авиабилета", "center-center-bold-border", 1, 2)
    nextColumn(); text("Пункт оформления" + "\n" + "авиабилета," + "\n" + "контрольный номер", "center-center-bold-border", 1, 2)
    nextColumn(); text("Вид тарифа", "center-center-bold-border", 1, 2)
    nextColumn(); text("Маршрут" + "\n" + "следования", "center-center-bold-border", 1, 2)
    nextColumn(); text("Дата" + "\n" + "продажи" + "\n" + "авиабилета", "center-center-bold-border", 1, 2)
    nextColumn(); text("Дата" + "\n" + "вылета", "center-center-bold-border", 1, 2)
    nextColumn(); text("Номер рейса", "center-center-bold-border", 1, 2)
    nextColumn(); text("Стоимость перевозной платы, руб.", "center-center-bold-border", 3, 1)
    nextColumn(); nextColumn()
    nextColumn(); text("Сбор за" + "\n" + "оформление", "center-center-bold-border", 1, 2)
    nextColumn(); text("Итого, руб", "center-center-bold-border", 1, 2)

    nextRow()
    9.times {
        nextColumn()
    }
    nextColumn(); text("Тариф", "center-center-bold-border")
    nextColumn(); text("Тариф с учетом" + "\n" + "скидки", "center-center-bold-border")
    nextColumn(); text("Сборы," + "\n" + "включенные в" + "\n" + "авиабилет", "center-center-bold-border")

    nextRow(); rowHeight(15)

    int i = 0
    15.times {
        i++
        text(String.valueOf(i))
        nextColumn()
    }

}

def printTickets() {
    Map<OperationBatch, List<AirTicketsTemplateReportTicket>> ticketsMap = collectTicketsByOpBatch()
    List<AirTicketsTemplateReportTicket> sellTickets = ticketsMap.get(OperationBatch.SELL)
    List<AirTicketsTemplateReportTicket> refundTickets = ticketsMap.get(OperationBatch.REFUND)

    printBatch(sellTickets, "Продажа")
    printBatch(refundTickets, "Возврат")

    nextRow(); text("ИТОГО:", "left-center-bold-border", 3, 1)

    9.times {
        nextColumn(); text("")
    }

    5.times {
        nextColumn()
        formula("${cellIndex(-(3 + refundTickets.size()), 0)}-${cellIndex(-1, 0)}", "center-center-border-number")
    }

    nextRow(); nextRow()
    2.times {
        nextColumn()
    }

    text("Требований ВПД - " + mtdCount(ticketsMap) +  " шт.", "left-center-bold", 2, 1)
}

def printBatch(List<AirTicketsTemplateReportTicket> ticketsList, String batchName) {
    SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy")

    nextRow(); text(batchName + ":", "left-center-bold-border", 15, 1)

    ticketsList.eachWithIndex { ticket, index ->
        nextRow(); rowHeight(15)

        text(String.valueOf(index + 1), "center-center-border")

        nextColumn()
        text("")

        nextColumn()
        text(ticket.militaryClaimNumber ? ticket.militaryClaimNumber : "")

        nextColumn()
        text((ticket.validatingCarrierNumber ? ticket.validatingCarrierNumber + " " : "") +
                (ticket.ticketNumber ? ticket.ticketNumber : ""))

        nextColumn()
        text(salesPointCity(ticket.salesPoint) + ", " + TextUtil.nonNullStr(ticket.validator))

        nextColumn()
        text(ticket.fareBasisLine != null ? ticket.fareBasisLine : "")

        nextColumn()
        text(route(ticket))

        nextColumn()
        text(ticket.issueDate ? sdf.format(ticket.issueDate) : "")

        nextColumn()
        text(ticket.departureDate ? sdf.format(ticket.departureDate) : "")

        nextColumn()
        text(TextUtil.join(", ", new LinkedHashSet(ticket.flightNumbers)))

        nextColumn()
        number(ticket.equivalentFare ? ticket.equivalentFare : BigDecimal.ZERO, "center-center-border-number")

        nextColumn()
        number(ticket.equivalentFare ? ticket.equivalentFare : BigDecimal.ZERO)

        nextColumn()
        number(ticket.taxesSum ? ticket.taxesSum : BigDecimal.ZERO)

        nextColumn()
        number(ticket.clientFeeValue ? ticket.clientFeeValue : BigDecimal.ZERO)

        nextColumn()
        number(ticket.price ? ticket.price : BigDecimal.ZERO)
    }

    nextRow(); text("Итого " + batchName.toLowerCase() + ":", "left-center-bold-border", 3, 1)

    9.times {
        nextColumn(); text("")
    }

    5.times {
        nextColumn()
        if (ticketsList.size() > 0) {
            formula("SUM(${cellIndex(-ticketsList.size(), 0)}:${cellIndex(-1, 0)})", "center-center-border-number")
        } else {
            number(BigDecimal.ZERO, "center-center-border-number")
        }
    }
}

def collectTicketsByOpBatch() {
    Map<OperationBatch, List<AirTicketsTemplateReportTicket>> result = new HashMap<>()
    result.put(OperationBatch.SELL, new ArrayList<>())
    result.put(OperationBatch.REFUND, new ArrayList<>())

    tickets { AirTicketsTemplateReportTicket ticket ->
        if (result.containsKey(ticket.operationBatch)) {
            result.get(ticket.operationBatch).add(ticket)
        } else {
            throw new IllegalArgumentException(
                    String.format("Ticket %s (uid %s) has illegal operation batch %s",
                            ticket.ticketNumber, ticket.uid, ticket.operationBatch))
        }
    }

    return result
}

def route(AirTicketsTemplateReportTicket ticket) {
    StringBuilder sb = new StringBuilder()

    ticket.segmentTariffs.each {
        it.segments.each {
            if (sb.length() > 0) {
                sb.append("-")
            }
            sb.append(locName(it.departureLocation))
                    .append("-")
                    .append(locName(it.arrivalLocation))
        }
    }

    return sb.toString()
}

def locName(DictionaryReference<GeoLocation> reference) {
    if (reference == null) {
        return ""
    }

    GeoLocation location = DictionaryCache.get().resolveReference(reference)
    if (location == null) {
        return reference.toString()
    }

    if (location.type != LocationType.CITY && location.parent != null) {
        return locName(location.parent)
    }

    return location.toString(LocaleHelper.RU_LOCALE)
}

def salesPointCity(EntityReference<SalesPoint> spReference) {
    if (spReference == null) {
        return ""
    }

    SalesPoint salesPoint = EntityStorage.get().resolve(spReference)?.getEntity()
    if (salesPoint == null) {
        return ""
    }

    for (Address address: salesPoint.getAddresses()) {
        DictionaryReference<GeoLocation> cityReference = address.getCity()
        if (cityReference != null) {
            return cityReference.toString(LocaleHelper.RU_LOCALE)
        }
    }

    return ""
}

def mtdCount(Map<OperationBatch, List<AirTicketsTemplateReportTicket>> ticketMap) {
    int res = 0

    Set<String> mtdNumbers = new HashSet<>()
    ticketMap.values().each {
        it.each {
            if (TextUtil.isBlank(it.militaryClaimNumber) || mtdNumbers.add(it.militaryClaimNumber)) {
                res++
            }
        }
    }

    return res
}

def setAutoWidth() {
    nextRow(); rowHeight(15); columnWidth(10)

    14.times {
        nextColumn()
        columnAutoWidth(true)
    }
}

page{"МВД ВВЛ " + parameters['title']} {
    printTitle()
    printHeader()
    printTickets()
    setAutoWidth()
}