package com.gridnine.xtrip.server.support.model.questionnaire.scripts

import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.model.asset.AssetsStorage
import com.gridnine.xtrip.common.model.assets.UserAccount
import com.gridnine.xtrip.common.model.booking.CommonProductIndex
import com.gridnine.xtrip.common.model.booking.ProductStatus
import com.gridnine.xtrip.common.model.booking.commission.ProductType
import com.gridnine.xtrip.common.model.dict.GdsName
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.questionnaire.RegisterAnswerSyncRequest
import com.gridnine.xtrip.common.parsers.model.AlfastrahExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.CCCExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.ExcessBagageExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.GabrielMaskExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.HotExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.HotelbookExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.InmobExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.IurExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.LiaisonExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.MCOExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.RenaissanceInsuranceExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.RetArchiveExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.RetExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.S7ExcelExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.SirenaXmlExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.SsodArchiveExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.SsodExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.TeletrainExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.UTSItineraryExchangeDocumentIndex
import com.gridnine.xtrip.common.railway.parsers.ExpressExchangeDocumentIndex
import com.gridnine.xtrip.common.railway.parsers.SPGDArchiveExchangeDocumentIndex
import com.gridnine.xtrip.common.railway.parsers.SPGDExchangeDocumentIndex
import com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocumentIndex
import com.gridnine.xtrip.common.search.Projection
import com.gridnine.xtrip.common.search.ProjectionQuery
import com.gridnine.xtrip.common.search.ResultMode
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil
import com.gridnine.xtrip.common.xml.XSUtil
import org.apache.commons.io.FileUtils

import java.text.SimpleDateFormat


def answer = new RegisterAnswerSyncRequest();


class DateInterval3{
    Date startDate;
    Date endDate;
    String title;
    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    DateInterval3(String startDate, String endDate, String title){
        this.startDate = MiscUtil.clearTime(df.parse(startDate));
        this.endDate = MiscUtil.setDayEndTime(df.parse(endDate));
        this.title = title;
    }
}

def periods = []

periods << new DateInterval3("2018-01-01", "2018-01-31","1801_January2018")
periods << new DateInterval3("2018-02-01", "2018-02-28","1802_February2018")
periods << new DateInterval3("2018-03-01", "2018-03-31","1803_March2018")
periods << new DateInterval3("2018-04-01", "2018-04-30","1804_April2018")
periods << new DateInterval3("2018-05-01", "2018-05-31","1805_May2018")
periods << new DateInterval3("2018-06-01", "2018-06-30","1806_June2018")
periods << new DateInterval3("2018-07-01", "2018-07-31","1807_July2018")
periods << new DateInterval3("2018-08-01", "2018-08-31","1808_August2018")

StringBuilder sb = new StringBuilder();


sb.append("\r\n\r\nProducts:\r\n")
int totalCount = periods.size()
int idx = 0;
periods.each { DateInterval3 period ->
    ProjectionQuery pq = new ProjectionQuery();
    pq.getCriteria().getCriterions().add(SearchCriterion.ge(CommonProductIndex.Property.issueDate.name(), period.startDate));
    pq.getCriteria().getCriterions().add(SearchCriterion.le(CommonProductIndex.Property.issueDate.name(), period.endDate));
    pq.getCriteria().getCriterions().add(SearchCriterion.ne(CommonProductIndex.Property.status.name(), ProductStatus.EXCHANGE));
    pq.projections.add(Projection.count(CommonProductIndex.Property.productType.name(),"_count"));
    pq.projections.add(Projection.group(CommonProductIndex.Property.productType.name(), "_type"))
    pq.projections.add(Projection.group(CommonProductIndex.Property.gdsName.name(), "_gds"))
    pq.projections.add(Projection.group(CommonProductIndex.Property.status.name(), "_status"))
    pq.criteria.orders.put(CommonProductIndex.Property.productType.name(), SortOrder.ASC);
    pq.criteria.orders.put(CommonProductIndex.Property.gdsName.name(), SortOrder.ASC);
    pq.criteria.orders.put(CommonProductIndex.Property.status.name(), SortOrder.ASC);
    def data = EntityStorage.get().search(CommonProductIndex.class, pq).getData();
    data.each {Map<String, Object> entry ->
        int count = entry.get("_count")
        ProductType type = entry.get("_type");
        GdsName gds = entry.get("_gds")
        ProductStatus status = entry.get("_status")
        sb.append("\n${Environment.getApplicationId()};${period.title};${type};${gds};${status};${count}");
    }
    idx++;
    progress("обработали ${idx} из ${totalCount}", (int) (100d*idx/totalCount))



}
answer.textData = sb.toString()
message(sb.toString())
String serialized = XSUtil.toString(answer)
FileUtils.write(new File(Environment.tempFolder, "answer.txt"), serialized)
